/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.world;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.SpellObjectManager;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorld;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorldCapability;
import com.teamwizardry.wizardry.common.core.nemez.NemezTracker;
import com.teamwizardry.wizardry.common.network.PacketSyncWizardryWorld;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StandardWizardryWorld
implements WizardryWorld {
    private World world;
    private SpellObjectManager spellObjectManager = new SpellObjectManager();
    public HashMap<BlockPos, NemezTracker> blockNemezDrives = new HashMap();
    public HashMap<UUID, NemezTracker> entityNemezDrives = new HashMap();

    public static StandardWizardryWorld create(World world) {
        StandardWizardryWorld wizardryWorld = new StandardWizardryWorld();
        wizardryWorld.world = world;
        return wizardryWorld;
    }

    public static StandardWizardryWorld create() {
        return new StandardWizardryWorld();
    }

    @Override
    public SpellObjectManager getSpellObjectManager() {
        return this.spellObjectManager;
    }

    @Override
    public NemezTracker addNemezDrive(BlockPos pos, NemezTracker nemezDrive) {
        this.blockNemezDrives.put(pos, nemezDrive);
        PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld(this.serializeNBT()), this.world.field_73011_w.getDimension());
        return nemezDrive;
    }

    @Override
    public NemezTracker addNemezDrive(UUID uuid, NemezTracker nemezDrive) {
        this.entityNemezDrives.put(uuid, nemezDrive);
        PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld(this.serializeNBT()), this.world.field_73011_w.getDimension());
        return nemezDrive;
    }

    @Override
    public void removeNemezDrive(BlockPos pos) {
        this.blockNemezDrives.remove(pos);
        PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld(this.serializeNBT()), this.world.field_73011_w.getDimension());
    }

    @Override
    public void removeNemezDrive(UUID uuid) {
        this.entityNemezDrives.remove(uuid);
        PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld(this.serializeNBT()), this.world.field_73011_w.getDimension());
    }

    @Override
    public HashMap<BlockPos, NemezTracker> getBlockNemezDrives() {
        return this.blockNemezDrives;
    }

    @Override
    public HashMap<UUID, NemezTracker> getEntityNemezDrives() {
        return this.entityNemezDrives;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("spell_object_manager", (NBTBase)this.spellObjectManager.manager.toNbt());
        NBTTagList driveNBT = new NBTTagList();
        for (Map.Entry<BlockPos, NemezTracker> entry : this.blockNemezDrives.entrySet()) {
            if (entry == null) continue;
            NBTTagCompound compound1 = new NBTTagCompound();
            compound1.func_74772_a("pos", entry.getKey().func_177986_g());
            compound1.func_74782_a("drive", (NBTBase)entry.getValue().serializeNBT());
            driveNBT.func_74742_a((NBTBase)compound1);
        }
        compound.func_74782_a("drives", (NBTBase)driveNBT);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("spell_object_manager")) {
            this.spellObjectManager = new SpellObjectManager();
            this.spellObjectManager.manager.fromNbt(compound.func_74775_l("spell_object_manager"));
        }
        if (compound.func_74764_b("drives")) {
            NBTTagList driveNBT = compound.func_150295_c("drives", 10);
            for (NBTBase base : driveNBT) {
                if (!(base instanceof NBTTagCompound) || !((NBTTagCompound)base).func_74764_b("pos") || !((NBTTagCompound)base).func_74764_b("drive")) continue;
                BlockPos pos = BlockPos.func_177969_a((long)((NBTTagCompound)base).func_74763_f("pos"));
                NemezTracker tracker = new NemezTracker();
                tracker.deserializeNBT(((NBTTagCompound)base).func_150295_c("drive", 10));
                this.blockNemezDrives.put(pos, tracker);
            }
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == WizardryWorldCapability.capability();
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == WizardryWorldCapability.capability() ? WizardryWorldCapability.capability().cast((Object)this) : null);
    }
}

