/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tracks.block;

import com.teamacronymcoders.base.blocks.IHasBlockStateMapper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import xyz.brassgoggledcoders.transport.library.block.track.BlockRailFoundation;
import xyz.brassgoggledcoders.transport.library.block.track.RailPredicates;

public class BlockRailHolding
extends BlockRailFoundation
implements IHasBlockStateMapper {
    public static final PropertyBool NORTH_WEST = PropertyBool.func_177716_a((String)"north_west");
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> SHAPE = PropertyEnum.func_177708_a((String)"shape", BlockRailBase.EnumRailDirection.class, RailPredicates.FLAT_STRAIGHT::test);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockRailHolding() {
        super("holding");
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177226_a((IProperty)NORTH_WEST, (Comparable)Boolean.valueOf(true)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && player.func_184586_b(hand).func_190926_b()) {
            state = state.func_177226_a((IProperty)NORTH_WEST, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)NORTH_WEST) == false));
            world.func_180501_a(pos, state, 3);
            return true;
        }
        return false;
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            float speedIncrease = 0.5f;
            if (((Boolean)state.func_177229_b((IProperty)NORTH_WEST)).booleanValue()) {
                speedIncrease *= -1.0f;
            }
            if (state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                cart.field_70179_y += (double)speedIncrease;
            } else {
                cart.field_70159_w += (double)speedIncrease;
            }
        } else {
            cart.field_70159_w = 0.0;
            cart.field_70181_x = 0.0;
            cart.field_70179_y = 0.0;
        }
    }

    protected void func_189541_b(IBlockState state, World world, BlockPos pos, Block block) {
        boolean isStatePowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        boolean isWorldPowered = world.func_175640_z(pos);
        if (isWorldPowered != isStatePowered) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(isWorldPowered)), 3);
            world.func_175685_c(pos.func_177977_b(), (Block)this, true);
        }
        super.func_189541_b(state, world, pos, block);
    }

    @Override
    public boolean canMakeSlopes(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE, POWERED, NORTH_WEST});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState blockState = this.func_176223_P();
        if (meta > 7) {
            meta -= 8;
            blockState = blockState.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (meta % 2 != 0) {
            blockState = blockState.func_177226_a((IProperty)NORTH_WEST, (Comparable)Boolean.valueOf(false));
        }
        if (meta > 1) {
            blockState = blockState.func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
        }
        return blockState;
    }

    @Override
    public int func_176201_c(IBlockState blockState) {
        int facing = blockState.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.NORTH_SOUTH ? 0 : 2;
        int powered = (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 8 : 0;
        return (facing += (Boolean)blockState.func_177229_b((IProperty)NORTH_WEST) != false ? 0 : 1) + powered;
    }

    public String getVariant(IBlockState blockState) {
        int facing = blockState.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.NORTH_SOUTH ? 0 : 2;
        return "facing=" + EnumFacing.field_82609_l[(facing += (Boolean)blockState.func_177229_b((IProperty)NORTH_WEST) != false ? 0 : 1) + 2] + ",powered=" + ((Boolean)blockState.func_177229_b((IProperty)POWERED)).toString();
    }

    @Override
    public IProperty<BlockRailBase.EnumRailDirection> func_176560_l() {
        return SHAPE;
    }
}

