/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.loaders.tileentity;

import com.teamacronymcoders.base.capability.item.ItemHandlerDirectional;
import com.teamacronymcoders.base.capability.item.ItemStackQueue;
import java.util.Optional;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import xyz.brassgoggledcoders.transport.library.tileentity.loader.TileEntityLoaderBase;

public class TileEntityItemLoader
extends TileEntityLoaderBase<IItemHandler> {
    private final ItemStackQueue itemStackQueue = new ItemStackQueue();
    private final IItemHandler itemHandlerInput = new ItemHandlerDirectional((IItemHandler)this.itemStackQueue, true);
    private final IItemHandler itemHandlerOutput = new ItemHandlerDirectional((IItemHandler)this.itemStackQueue, false);

    protected void readCapability(NBTTagCompound data) {
        this.itemStackQueue.deserializeNBT(data.func_74775_l("inventory"));
    }

    protected void writeCapability(NBTTagCompound data) {
        data.func_74782_a("inventory", (NBTBase)this.itemStackQueue.serializeNBT());
    }

    public Capability<IItemHandler> getCapabilityType() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public IItemHandler getInternalCapability() {
        return this.itemStackQueue;
    }

    public IItemHandler getOutputCapability() {
        return this.itemHandlerOutput;
    }

    public IItemHandler getInputCapability() {
        return this.itemHandlerInput;
    }

    @Override
    protected boolean transfer(IItemHandler from, IItemHandler to) {
        for (int fromIndex = 0; fromIndex < from.getSlots(); ++fromIndex) {
            ItemStack itemStackSimPushed;
            ItemStack itemStackSimPulled = from.extractItem(fromIndex, 64, true);
            if (itemStackSimPulled.func_190926_b() || !(itemStackSimPushed = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)itemStackSimPulled, (boolean)true)).func_190926_b()) continue;
            ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)from.extractItem(fromIndex, 64, false), (boolean)false);
            return true;
        }
        return false;
    }

    public void dropItems() {
        Optional itemStack = this.itemStackQueue.pull();
        while (itemStack.isPresent()) {
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)((ItemStack)itemStack.get()));
            itemStack = this.itemStackQueue.pull();
        }
    }
}

