/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import prospector.traverse.commands.CommandFindBiome;
import prospector.traverse.config.TraverseConfig;
import prospector.traverse.init.TraverseBlocks;
import prospector.traverse.shadow.shootingstar.ShootingStar;
import prospector.traverse.shadow.shootingstar.version.VersionUtils;
import prospector.traverse.util.TUtils;
import prospector.traverse.world.TraverseWorld;
import prospector.traverse.world.TraverseWorldVersion;

@Mod.EventBusSubscriber
public class TraverseCommon {
    public static TraverseWorldVersion traverse_world_data = null;

    static void registerSmeltingRecipe(ItemStack output, ItemStack input, float experience) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)experience);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ShootingStar.registerModels("traverse");
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ShootingStar.registerBlocks("traverse", event);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ShootingStar.registerItems("traverse", event);
    }

    public void preInit(FMLPreInitializationEvent event) {
        TraverseBlocks.test();
        TraverseConfig.initialize(event);
        MinecraftForge.TERRAIN_GEN_BUS.register(TraverseWorld.class);
    }

    public void init(FMLInitializationEvent event) {
        for (Block block : TraverseBlocks.oreDictNames.keySet()) {
            OreDictionary.registerOre((String)TraverseBlocks.oreDictNames.get(block), (Block)block);
        }
        for (TraverseWorld.TraverseBiomeEntry traverseBiome : TraverseWorld.biomeList) {
            BiomeManager.addBiome((BiomeManager.BiomeType)traverseBiome.getType(), (BiomeManager.BiomeEntry)traverseBiome.getEntry());
            if (traverseBiome.hasVillages()) {
                BiomeManager.addVillageBiome((Biome)traverseBiome.getBiome(), (boolean)traverseBiome.canSpawn());
            }
            if (traverseBiome.canSpawn()) {
                BiomeManager.addSpawnBiome((Biome)traverseBiome.getBiome());
            }
            BiomeProvider.allowedBiomes.add(traverseBiome.getBiome());
        }
        TraverseCommon.registerSmeltingRecipe(new ItemStack(Items.field_151044_h, 1, 1), new ItemStack(TUtils.getBlock("fir_log")), 0.15f);
        TraverseCommon.registerSmeltingRecipe(new ItemStack(TUtils.getBlock("red_rock")), new ItemStack(TUtils.getBlock("red_rock_cobblestone")), 0.1f);
        TraverseCommon.registerSmeltingRecipe(new ItemStack(TUtils.getBlock("blue_rock")), new ItemStack(TUtils.getBlock("blue_rock_cobblestone")), 0.1f);
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandFindBiome());
    }

    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        File worldDir;
        traverse_world_data = null;
        File rootDir = FMLCommonHandler.instance().getSavesDirectory();
        if (!rootDir.exists()) {
            rootDir.mkdir();
        }
        if (!(worldDir = new File(rootDir, event.getServer().func_71270_I())).exists()) {
            worldDir.mkdir();
        }
        traverse_world_data = new TraverseWorldVersion(worldDir);
        for (TraverseWorld.TraverseBiomeEntry traverseBiome : TraverseWorld.biomeList) {
            boolean canRegister;
            BiomeProvider.allowedBiomes.remove(traverseBiome.getBiome());
            BiomeManager.removeSpawnBiome((Biome)traverseBiome.getBiome());
            BiomeManager.removeBiome((BiomeManager.BiomeType)traverseBiome.getType(), (BiomeManager.BiomeEntry)traverseBiome.getEntry());
            if (!TraverseConfig.registerBiomesRegardless) {
                traverse_world_data.reloadVersionFile();
                canRegister = VersionUtils.isVersionLessOrEqual(traverseBiome.getVersionAdded(), TraverseCommon.traverse_world_data.version);
            } else {
                canRegister = true;
            }
            if (!canRegister) continue;
            BiomeManager.addBiome((BiomeManager.BiomeType)traverseBiome.getType(), (BiomeManager.BiomeEntry)traverseBiome.getEntry());
            if (traverseBiome.hasVillages()) {
                BiomeManager.addVillageBiome((Biome)traverseBiome.getBiome(), (boolean)traverseBiome.canSpawn());
            }
            if (traverseBiome.canSpawn()) {
                BiomeManager.addSpawnBiome((Biome)traverseBiome.getBiome());
            }
            BiomeProvider.allowedBiomes.add(traverseBiome.getBiome());
        }
    }

    public void serverStopping(FMLServerStoppingEvent event) {
    }
}

