/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler;

import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.VanillaEntityItemCapabilityDelegator;

public class VanillaEntityItemFluidHandler
extends VanillaEntityItemCapabilityDelegator<IFluidHandlerItem>
implements IFluidHandler {
    public VanillaEntityItemFluidHandler(EntityItem entity, EnumFacing side) {
        super(entity, side);
    }

    @Override
    protected Capability<IFluidHandlerItem> getCapabilityType() {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)this.getCapability();
        if (fluidHandler != null) {
            return fluidHandler.getTankProperties();
        }
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)this.getCapability();
        if (fluidHandler != null) {
            int ret = fluidHandler.fill(resource, doFill);
            if (ret > 0 && doFill) {
                this.updateItemStack(fluidHandler.getContainer());
            }
            return ret;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)this.getCapability();
        if (fluidHandler != null) {
            FluidStack ret = fluidHandler.drain(resource, doDrain);
            if (ret != null && doDrain) {
                this.updateItemStack(fluidHandler.getContainer());
            }
            return ret;
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)this.getCapability();
        if (fluidHandler != null) {
            FluidStack ret = fluidHandler.drain(maxDrain, doDrain);
            if (ret != null && doDrain) {
                this.updateItemStack(fluidHandler.getContainer());
            }
            return ret;
        }
        return null;
    }
}

