/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import journeymap.common.network.impl.Message;
import journeymap.common.network.impl.NetworkHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Logger;

public class MessageListener
implements IMessageHandler<Message, IMessage> {
    private Logger logger = NetworkHandler.getLogger();

    public IMessage onMessage(Message message, MessageContext ctx) {
        Gson gson = new GsonBuilder().serializeNulls().create();
        try {
            JsonObject response = (JsonObject)gson.fromJson(message.getMessage(), JsonObject.class);
            String clazz = response.get("container_object").getAsString();
            Class<?> requestObject = Class.forName(clazz);
            Method method = requestObject.getMethod("process", JsonObject.class, MessageContext.class, Class.class);
            method.invoke(null, response, ctx, requestObject);
        }
        catch (ClassNotFoundException e) {
            this.logger.warn("Message processor not found: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Cannot access message processor: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            this.logger.warn("Null Response: ", (Throwable)e);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            this.logger.warn("Unable to initiate message processing", (Throwable)e);
        }
        return null;
    }
}

