/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityLiquidCompressor
extends TileEntityPneumaticBase
implements IRedstoneControlled,
ISerializableTanks {
    public static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    @GuiSynced
    private final FluidTank tank = new FluidTank(16000);
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || FluidUtil.getFluidHandler((ItemStack)itemStack) != null;
        }
    };
    @GuiSynced
    public int redstoneMode;
    private double internalFuelBuffer;
    @DescSynced
    @GuiSynced
    public boolean isProducing;

    public TileEntityLiquidCompressor() {
        this(5.0f, 7.0f, 5000);
    }

    public TileEntityLiquidCompressor(float dangerPressure, float criticalPressure, int volume) {
        super(dangerPressure, criticalPressure, volume, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    private int getFuelValue(FluidStack fluid) {
        return fluid == null ? 0 : this.getFuelValue(fluid.getFluid());
    }

    private int getFuelValue(Fluid fluid) {
        Integer value = PneumaticCraftAPIHandler.getInstance().liquidFuels.get(fluid.getName());
        return value == null ? 0 : value;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            this.processFluidItem(0, 1);
            this.isProducing = false;
            if (this.redstoneAllows()) {
                double fuelValue;
                int usageRate = (int)((float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades());
                if (this.internalFuelBuffer < (double)usageRate && (fuelValue = (double)this.getFuelValue(this.tank.getFluid()) / 1000.0) > 0.0) {
                    int usedFuel = Math.min(this.tank.getFluidAmount(), (int)((double)usageRate / fuelValue) + 1);
                    this.tank.drain(usedFuel, true);
                    this.internalFuelBuffer += (double)usedFuel * fuelValue;
                }
                if (this.internalFuelBuffer >= (double)usageRate) {
                    this.isProducing = true;
                    this.internalFuelBuffer -= (double)usageRate;
                    this.onFuelBurn(usageRate);
                    this.addAir((int)((float)this.getBaseProduction() * this.getSpeedMultiplierFromUpgrades() * (float)this.getEfficiency() / 100.0f));
                }
            }
        } else if (this.isProducing && this.field_145850_b.field_73012_v.nextInt(5) == 0) {
            ClientUtils.emitParticles(this.func_145831_w(), this.func_174877_v(), EnumParticleTypes.SMOKE_NORMAL);
        }
    }

    protected void onFuelBurn(int burnedFuel) {
    }

    public int getEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    @Override
    public boolean isConnectedTo(EnumFacing dir) {
        EnumFacing orientation = this.getRotation();
        return orientation == dir || orientation == dir.func_176734_d() || dir == EnumFacing.UP;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        tag.func_74780_a("internalFuelBuffer", this.internalFuelBuffer);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.internalFuelBuffer = tag.func_74769_h("internalFuelBuffer");
    }

    @Override
    public String getName() {
        return Blockss.LIQUID_COMPRESSOR.func_149739_a();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }
}

