/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.entity_tracker;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderDroneAI;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.HackUpgradeHandler;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class EntityTrackHandler {
    private static final List<IEntityTrackEntry> trackEntries = new ArrayList<IEntityTrackEntry>();

    public static void registerDefaultEntries() {
        IPneumaticHelmetRegistry manager = PneumaticRegistry.getInstance().getHelmetRegistry();
        manager.registerEntityTrackEntry(EntityTrackEntryLivingBase.class);
        manager.registerEntityTrackEntry(EntityTrackEntryHackable.class);
        manager.registerEntityTrackEntry(EntityTrackEntryDrone.class);
        manager.registerEntityTrackEntry(EntityTrackEntryPressurizable.class);
        manager.registerEntityTrackEntry(EntityTrackEntryAgeable.class);
        manager.registerEntityTrackEntry(EntityTrackEntryTameable.class);
        manager.registerEntityTrackEntry(EntityTrackEntryCreeper.class);
        manager.registerEntityTrackEntry(EntityTrackEntrySlime.class);
        manager.registerEntityTrackEntry(EntityTrackEntryPlayer.class);
        manager.registerEntityTrackEntry(EntityTrackEntryMob.class);
        manager.registerEntityTrackEntry(EntityTrackEntryItemFrame.class);
        manager.registerEntityTrackEntry(EntityTrackEntryPainting.class);
    }

    public static void init() {
        for (Class<? extends IEntityTrackEntry> clazz : PneumaticHelmetRegistry.getInstance().entityTrackEntries) {
            try {
                trackEntries.add(clazz.newInstance());
            }
            catch (InstantiationException e) {
                Log.error("[Entity Tracker] Couldn't registrate " + clazz.getName() + ". Does it have a parameterless constructor?");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Log.error("[Entity Tracker] Couldn't registrate " + clazz.getName() + ". Is it a public class?");
                e.printStackTrace();
            }
        }
    }

    public static List<IEntityTrackEntry> getTrackersForEntity(Entity entity) {
        ArrayList<IEntityTrackEntry> trackers = new ArrayList<IEntityTrackEntry>();
        for (IEntityTrackEntry tracker : trackEntries) {
            if (!tracker.isApplicable(entity)) continue;
            try {
                IEntityTrackEntry newTracker = (IEntityTrackEntry)tracker.getClass().newInstance();
                newTracker.isApplicable(entity);
                trackers.add(newTracker);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return trackers;
    }

    private static ItemStack[] asItemStackArray(NonNullList<ItemStack> stacks) {
        return (ItemStack[])stacks.stream().filter(stack -> !stack.func_190926_b()).toArray(ItemStack[]::new);
    }

    public static class EntityTrackEntryItemFrame
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityItemFrame;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            EntityItemFrame frame = (EntityItemFrame)entity;
            ItemStack stack = frame.func_82335_i();
            if (!stack.func_190926_b()) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.itemframe.item", (Object[])new Object[]{stack.func_82833_r()}));
                if (frame.func_82333_j() != 0) {
                    curInfo.add(I18n.func_135052_a((String)"entityTracker.info.itemframe.rotation", (Object[])new Object[]{frame.func_82333_j() * 45}));
                }
            }
        }
    }

    public static class EntityTrackEntryPainting
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityPainting;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            EntityPainting.EnumArt art = ((EntityPainting)entity).field_70522_e;
            if (art != null) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.painting.art", (Object[])new Object[]{art.field_75702_A}));
            }
        }
    }

    public static class EntityTrackEntryHackable
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return HackUpgradeHandler.enabledForPlayer(PneumaticCraftRepressurized.proxy.getClientPlayer());
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            IHackableEntity hackable = HackableHandler.getHackableForEntity(entity, PneumaticCraftRepressurized.proxy.getClientPlayer());
            if (hackable != null) {
                int hackTime = HUDHandler.instance().getSpecificRenderer(EntityTrackUpgradeHandler.class).getTargetsStream().filter(target -> target.entity == entity).findFirst().map(RenderEntityTarget::getHackTime).orElse(0);
                if (hackTime == 0) {
                    if (isLookingAtTarget) {
                        hackable.addInfo(entity, curInfo, PneumaticCraftRepressurized.proxy.getClientPlayer());
                        HackUpgradeHandler.addKeybindTooltip(curInfo);
                    }
                } else {
                    int requiredHackTime = hackable.getHackTime(entity, PneumaticCraftRepressurized.proxy.getClientPlayer());
                    int percentageComplete = hackTime * 100 / requiredHackTime;
                    if (percentageComplete < 100) {
                        curInfo.add(I18n.func_135052_a((String)"pneumaticHelmet.hacking.hacking", (Object[])new Object[]{percentageComplete}));
                    } else if (hackTime < requiredHackTime + 20) {
                        hackable.addPostHackInfo(entity, curInfo, PneumaticCraftRepressurized.proxy.getClientPlayer());
                    } else if (isLookingAtTarget) {
                        hackable.addInfo(entity, curInfo, PneumaticCraftRepressurized.proxy.getClientPlayer());
                        HackUpgradeHandler.addKeybindTooltip(curInfo);
                    }
                }
            }
        }
    }

    public static class EntityTrackEntryPlayer
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityPlayer;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            EntityPlayer player = (EntityPlayer)entity;
            curInfo.add(TextFormatting.GRAY + I18n.func_135052_a((String)"entityTracker.info.player.armor", (Object[])new Object[0]));
            int l = curInfo.size();
            PneumaticCraftUtils.sortCombineItemStacksAndToString(curInfo, EntityTrackHandler.asItemStackArray((NonNullList<ItemStack>)player.field_71071_by.field_70460_b));
            if (l == curInfo.size()) {
                curInfo.add(I18n.func_135052_a((String)"gui.misc.no_items", (Object[])new Object[0]));
            }
            l = curInfo.size();
            curInfo.add(TextFormatting.GRAY + I18n.func_135052_a((String)"entityTracker.info.player.holding", (Object[])new Object[0]));
            PneumaticCraftUtils.sortCombineItemStacksAndToString(curInfo, EntityTrackHandler.asItemStackArray((NonNullList<ItemStack>)player.field_71071_by.field_70462_a));
            if (l == curInfo.size()) {
                curInfo.add(I18n.func_135052_a((String)"gui.misc.no_items", (Object[])new Object[0]));
            }
        }
    }

    public static class EntityTrackEntryCreeper
    extends IEntityTrackEntry.EntityTrackEntry {
        private int creeperInFuseTime;

        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityCreeper;
        }

        @Override
        public void update(Entity entity) {
            if (((EntityCreeper)entity).func_70832_p() == 1) {
                ++this.creeperInFuseTime;
                if (this.creeperInFuseTime > 30) {
                    this.creeperInFuseTime = 30;
                }
            } else {
                --this.creeperInFuseTime;
                if (this.creeperInFuseTime < 0) {
                    this.creeperInFuseTime = 0;
                }
            }
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            if (this.creeperInFuseTime > 0) {
                if (((EntityCreeper)entity).func_70832_p() == 1) {
                    curInfo.add(TextFormatting.RED + I18n.func_135052_a((String)"entityTracker.info.creeper.fuse", (Object[])new Object[]{(float)Math.round((float)(30 - this.creeperInFuseTime) / 20.0f * 10.0f) / 10.0f + "s !"}));
                } else {
                    curInfo.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"entityTracker.info.creeper.coolDown", (Object[])new Object[]{(float)Math.round((float)(30 - this.creeperInFuseTime) / 20.0f * 10.0f) / 10.0f + "s !"}));
                }
            }
        }
    }

    public static class EntityTrackEntryTameable
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityTameable;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            EntityLivingBase owner = ((EntityTameable)entity).func_70902_q();
            if (owner != null) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.tamed", (Object[])new Object[]{owner.func_145748_c_().func_150260_c()}));
            } else {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.canTame", (Object[])new Object[0]));
            }
        }
    }

    public static class EntityTrackEntryAgeable
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityAgeable;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            int growingAge = ((EntityAgeable)entity).func_70874_b();
            if (growingAge > 0) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.canBreedIn", (Object[])new Object[]{PneumaticCraftUtils.convertTicksToMinutesAndSeconds(growingAge, false)}));
            } else if (growingAge < 0) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.growsUpIn", (Object[])new Object[]{PneumaticCraftUtils.convertTicksToMinutesAndSeconds(-growingAge, false)}));
            } else {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.canBreedNow", (Object[])new Object[0]));
            }
        }
    }

    public static class EntityTrackEntryMob
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityMob;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            EntityLivingBase target = ((EntityMob)entity).func_70638_az();
            if (target != null) {
                curInfo.add("Target: " + target.func_145748_c_().func_150260_c());
            }
        }
    }

    public static class EntityTrackEntrySlime
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntitySlime;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            switch (((EntitySlime)entity).func_70809_q()) {
                case 1: {
                    curInfo.add("Size: Tiny");
                    break;
                }
                case 2: {
                    curInfo.add("Size: Small");
                    break;
                }
                case 4: {
                    curInfo.add("Size: Big");
                    break;
                }
                default: {
                    curInfo.add("Size: " + ((EntitySlime)entity).func_70809_q());
                }
            }
        }
    }

    public static class EntityTrackEntryLivingBase
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityLivingBase;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            int healthPercentage = (int)(((EntityLivingBase)entity).func_110143_aJ() / ((EntityLivingBase)entity).func_110138_aP() * 100.0f);
            curInfo.add(I18n.func_135052_a((String)"entityTracker.info.health", (Object[])new Object[]{healthPercentage}));
        }
    }

    public static class EntityTrackEntryPressurizable
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof IPressurizable;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            curInfo.add(I18n.func_135052_a((String)"gui.tooltip.pressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((IPressurizable)entity).getPressure(null), 1)}));
        }
    }

    public static class EntityTrackEntryDrone
    extends IEntityTrackEntry.EntityTrackEntry {
        private RenderDroneAI droneAIRenderer;

        @Override
        public boolean isApplicable(Entity entity) {
            if (entity instanceof EntityDrone) {
                this.droneAIRenderer = new RenderDroneAI((EntityDrone)entity);
                return true;
            }
            return false;
        }

        public RenderDroneAI getDroneAIRenderer() {
            return this.droneAIRenderer;
        }

        @Override
        public void update(Entity entity) {
            this.droneAIRenderer.update();
        }

        @Override
        public void render(Entity entity, float partialTicks) {
            this.droneAIRenderer.render(partialTicks);
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            curInfo.add(I18n.func_135052_a((String)"entityTracker.info.tamed", (Object[])new Object[]{((EntityDrone)entity).playerName}));
            curInfo.add(I18n.func_135052_a((String)"entityTracker.info.drone.routine", (Object[])new Object[]{((EntityDrone)entity).getLabel()}));
            EntityPlayer player = PneumaticCraftRepressurized.proxy.getClientPlayer();
            if (DroneDebugUpgradeHandler.enabledForPlayer(player)) {
                if (NBTUtil.getInteger(player.func_184582_a(EntityEquipmentSlot.HEAD), "debuggingDrone") == entity.func_145782_y()) {
                    curInfo.add(TextFormatting.GOLD + I18n.func_135052_a((String)"entityTracker.info.drone.debugging", (Object[])new Object[0]));
                    curInfo.add(TextFormatting.GOLD + I18n.func_135052_a((String)"entityTracker.info.drone.debugging.key", (Object[])new Object[]{Keyboard.getKeyName((int)KeyHandler.getInstance().keybindOpenOptions.func_151463_i())}));
                } else if (isLookingAtTarget) {
                    curInfo.add(TextFormatting.GOLD + I18n.func_135052_a((String)"entityTracker.info.drone.pressDebugKey", (Object[])new Object[]{Keyboard.getKeyName((int)KeyHandler.getInstance().keybindDebuggingDrone.func_151463_i())}));
                }
            }
        }
    }
}

