/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.IWidgetListener;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.common.config.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;

public class GuiAnimatedStat
implements IGuiAnimatedStat,
IGuiWidget,
IWidgetListener {
    private static final int ANIMATED_STAT_SPEED = 30;
    private static final int WIDGET_SCROLLBAR_ID = -1000;
    private IGuiAnimatedStat affectingStat;
    private StatIcon statIcon;
    private final GuiScreen gui;
    private final List<String> textList = new ArrayList<String>();
    private final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    private int baseX;
    private int baseY;
    private int affectedY;
    private int width;
    private int height;
    private int oldBaseX;
    private int oldAffectedY;
    private int oldWidth;
    private int oldHeight;
    private boolean isClicked = false;
    private int minWidth = 17;
    private int minHeight = 17;
    private int backGroundColor;
    private Color bgColorHi;
    private Color bgColorLo;
    private String title;
    private boolean leftSided;
    private boolean doneExpanding;
    private float textSize;
    private float textScale = 1.0f;
    private IWidgetListener listener;
    private int curScroll;
    private static final int MAX_LINES = 12;
    private int lastMouseX;
    private int lastMouseY;
    private int lineSpacing = 10;
    private int widgetOffsetLeft = 0;
    private int widgetOffsetRight = 0;
    private boolean bevel = false;
    private Pair<Integer, Integer> forcedDimensions = null;

    public GuiAnimatedStat(GuiScreen gui, String title, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this.gui = gui;
        this.baseX = xPos;
        this.baseY = yPos;
        this.affectingStat = affectingStat;
        this.width = this.minWidth;
        this.height = this.minHeight;
        this.backGroundColor = backGroundColor;
        this.calculateColorHighlights(this.backGroundColor);
        this.setTitle(title);
        this.statIcon = StatIcon.NONE;
        this.leftSided = leftSided;
        this.textSize = 1.0f;
        this.affectedY = this.baseY;
        if (affectingStat != null) {
            this.affectedY += affectingStat.getAffectedY() + affectingStat.getHeight();
        }
    }

    public GuiAnimatedStat(GuiScreen gui, int backgroundColor) {
        this(gui, "", 0, 0, backgroundColor, null, false);
    }

    public GuiAnimatedStat(GuiScreen gui, int backgroundColor, ItemStack icon) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(icon);
    }

    public GuiAnimatedStat(GuiScreen gui, int backgroundColor, String texture) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(PneumaticCraftUtils.RL(texture));
    }

    public GuiAnimatedStat(GuiScreen gui, String title, StatIcon icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, affectingStat, leftSided);
        this.statIcon = icon;
    }

    public GuiAnimatedStat(GuiScreen gui, String title, StatIcon icon, int backGroundColor, IGuiAnimatedStat affectingStat, ArmorHUDLayout.LayoutItem layout) {
        this(gui, title, 0, 0, backGroundColor, affectingStat, layout.isLeftSided());
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int x = layout.getX() == -1.0f ? sr.func_78326_a() - 2 : (int)((float)sr.func_78326_a() * layout.getX());
        this.setBaseX(x);
        this.setBaseY((int)((float)sr.func_78328_b() * layout.getY()));
        this.statIcon = icon;
    }

    @Override
    public void setParentStat(IGuiAnimatedStat stat) {
        this.affectingStat = stat;
    }

    public void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    public void removeWidget(IGuiWidget widget) {
        this.widgets.remove(widget);
    }

    public void setWidgetOffsets(int left, int right) {
        this.widgetOffsetLeft = left;
        this.widgetOffsetRight = right;
    }

    @Override
    public Rectangle getButtonScaledRectangle(int origX, int origY, int width, int height) {
        int scaledX = (int)((float)origX * this.textSize);
        int scaledY = (int)((float)origY * this.textSize);
        return new Rectangle(scaledX, scaledY, (int)((float)width * this.textSize), (int)((float)height * this.textSize));
    }

    @Override
    public void scaleTextSize(float scale) {
        this.textSize *= scale;
        this.textScale = scale;
        for (IGuiWidget widget : this.widgets) {
            if (widget.getID() != -1000) continue;
            this.widgets.remove(widget);
            break;
        }
        this.onTextChange();
    }

    @Override
    public boolean isLeftSided() {
        return this.leftSided;
    }

    @Override
    public void setLeftSided(boolean leftSided) {
        this.leftSided = leftSided;
    }

    @Override
    public IGuiAnimatedStat setText(List<String> text) {
        this.textList.clear();
        for (String line : text) {
            this.textList.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)line, (Object[])new Object[0]), (int)(26.0f / this.textScale)));
        }
        this.onTextChange();
        return this;
    }

    @Override
    public IGuiAnimatedStat setText(String text) {
        this.textList.clear();
        this.textList.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)text, (Object[])new Object[0]), (int)(26.0f / this.textScale)));
        this.onTextChange();
        return this;
    }

    @Override
    public void setTextWithoutCuttingString(List<String> text) {
        this.textList.clear();
        this.textList.addAll(text);
        this.onTextChange();
    }

    @Override
    public void appendText(List<String> text) {
        for (String line : text) {
            this.textList.addAll(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)line, (Object[])new Object[0]), (int)(26.0f / this.textScale)));
        }
        this.onTextChange();
    }

    @Override
    public void addPadding(int nRows, int nCols) {
        String s = Strings.repeat((String)" ", (int)nCols);
        this.setTextWithoutCuttingString(IntStream.range(0, nRows).mapToObj(i -> s).collect(Collectors.toList()));
    }

    @Override
    public void addPadding(List<String> text, int nRows, int nCols) {
        String s = Strings.repeat((String)" ", (int)nCols);
        List<String> l = IntStream.range(0, nRows).mapToObj(i -> s).collect(Collectors.toList());
        for (int i2 = 0; i2 < text.size() && i2 < nRows; ++i2) {
            l.set(i2, text.get(i2));
        }
        this.setTextWithoutCuttingString(l);
    }

    @Override
    public void setBackGroundColor(int backGroundColor) {
        if (backGroundColor != this.backGroundColor) {
            this.backGroundColor = backGroundColor;
            this.calculateColorHighlights(backGroundColor);
        }
    }

    @Override
    public int getBackgroundColor() {
        return this.backGroundColor;
    }

    private void calculateColorHighlights(int color) {
        if (ConfigHandler.client.guiBevel) {
            float fgR = (float)(color >> 16 & 0xFF) / 255.0f;
            float fgG = (float)(color >> 8 & 0xFF) / 255.0f;
            float fgB = (float)(color & 0xFF) / 255.0f;
            float fgA = (float)(color >> 24 & 0xFF) / 255.0f;
            Color c = new Color(fgR, fgG, fgB, fgA);
            if (this.bevel) {
                this.bgColorHi = c.brighter();
                this.bgColorLo = c.darker();
            } else {
                this.bgColorLo = this.bgColorHi = c.darker().darker();
            }
        } else {
            this.bgColorLo = this.bgColorHi = Color.BLACK;
        }
    }

    @Override
    public void setBeveled(boolean bevel) {
        this.bevel = bevel;
        this.calculateColorHighlights(this.backGroundColor);
    }

    private void onTextChange() {
        if (this.textList.size() > 12) {
            for (IGuiWidget widget : this.widgets) {
                if (widget.getID() != -1000) continue;
                return;
            }
            this.curScroll = 0;
            this.addWidget(new WidgetVerticalScrollbar(-1000, this.leftSided ? -16 : 2, 20, (int)((float)(12 * this.lineSpacing - 20) * this.textSize)).setStates(this.textList.size() - 12));
        } else {
            Iterator<IGuiWidget> iterator = this.widgets.iterator();
            while (iterator.hasNext()) {
                IGuiWidget widget = iterator.next();
                if (widget.getID() != -1000) continue;
                iterator.remove();
                this.curScroll = 0;
            }
        }
    }

    @Override
    public void setMinDimensionsAndReset(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.width = minWidth;
        this.height = minHeight;
    }

    @Override
    public void setForcedDimensions(int width, int height) {
        this.forcedDimensions = width > 0 && height > 0 ? Pair.of((Object)width, (Object)height) : null;
    }

    @Override
    public void update() {
        this.oldBaseX = this.baseX;
        this.oldAffectedY = this.affectedY;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.doneExpanding = true;
        if (this.isClicked) {
            Pair<Integer, Integer> maxSize = this.calculateMaxSize();
            int maxWidth = (Integer)maxSize.getLeft();
            int maxHeight = (Integer)maxSize.getRight();
            this.width = Math.min(maxWidth, this.width + 30);
            this.height = Math.min(maxHeight, this.height + 30);
            this.doneExpanding = this.width == maxWidth && this.height == maxHeight;
            Pair<Integer, Integer> size = PneumaticCraftRepressurized.proxy.getScaledScreenSize();
            if (this.isLeftSided()) {
                if (this.baseX >= (Integer)size.getLeft()) {
                    this.baseX = (Integer)size.getLeft();
                }
            } else if (this.baseX < 0) {
                this.baseX = 1;
            }
            if (this.baseY + this.height >= (Integer)size.getRight()) {
                this.baseY = (Integer)size.getRight() - this.height - 1;
            }
            if (this.doneExpanding) {
                for (IGuiWidget widget : this.widgets) {
                    if (widget.getID() != -1000) continue;
                    this.curScroll = ((WidgetVerticalScrollbar)widget).getState();
                    break;
                }
            }
        } else {
            this.width = Math.max(this.minWidth, this.width - 30);
            this.height = Math.max(this.minHeight, this.height - 30);
            this.doneExpanding = false;
        }
        this.affectedY = this.baseY;
        if (this.affectingStat != null) {
            this.affectedY += this.affectingStat.getAffectedY() + this.affectingStat.getHeight();
        }
    }

    private Pair<Integer, Integer> calculateMaxSize() {
        int maxHeight;
        int availableWidth;
        if (this.forcedDimensions != null) {
            return this.forcedDimensions;
        }
        FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        if (this.gui instanceof GuiContainer) {
            GuiContainer gc = (GuiContainer)this.gui;
            availableWidth = this.leftSided ? gc.getGuiLeft() : gc.field_146294_l - (gc.getGuiLeft() + gc.getXSize());
        } else {
            availableWidth = new ScaledResolution(Minecraft.func_71410_x()).func_78326_a();
        }
        int maxWidth = fontRenderer.func_78256_a(this.title);
        for (String line : this.textList) {
            maxWidth = Math.max(maxWidth, fontRenderer.func_78256_a(line));
        }
        maxWidth += 20;
        int n = maxHeight = this.title.isEmpty() ? 6 : 16;
        if (!this.textList.isEmpty()) {
            maxHeight += Math.min(12, this.textList.size()) * this.lineSpacing;
        }
        maxHeight -= this.lineSpacing - fontRenderer.field_78288_b;
        float lastTextSize = this.textSize;
        if (maxWidth > availableWidth - 3) {
            this.textSize = ((float)availableWidth - 3.0f) / (float)maxWidth;
            maxWidth = (int)((float)maxWidth * this.textSize);
            maxHeight = (int)((float)maxHeight * this.textSize);
        } else {
            this.textSize = 1.0f;
        }
        if (lastTextSize != this.textSize) {
            float newTextSize = this.textSize;
            this.textSize = 1.0f;
            this.scaleTextSize(newTextSize);
        }
        return Pair.of((Object)maxWidth, (Object)maxHeight);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        int titleYoffset;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        float zLevel = 0.0f;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int renderBaseX = (int)((float)this.oldBaseX + (float)(this.baseX - this.oldBaseX) * partialTicks);
        int renderAffectedY = (int)((float)this.oldAffectedY + (float)(this.affectedY - this.oldAffectedY) * partialTicks);
        int renderWidth = (int)((float)this.oldWidth + (float)(this.width - this.oldWidth) * partialTicks);
        int renderHeight = (int)((float)this.oldHeight + (float)(this.height - this.oldHeight) * partialTicks);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        Gui.func_73734_a((int)renderBaseX, (int)renderAffectedY, (int)(renderBaseX + renderWidth), (int)(renderAffectedY + renderHeight), (int)this.backGroundColor);
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        float[] c1 = this.leftSided ? this.bgColorLo.getComponents(null) : this.bgColorHi.getComponents(null);
        float[] c2 = this.bgColorHi.getComponents(null);
        float[] c3 = this.leftSided ? this.bgColorHi.getComponents(null) : this.bgColorLo.getComponents(null);
        float[] c4 = this.bgColorLo.getComponents(null);
        wr.func_181662_b((double)renderBaseX, (double)renderAffectedY, (double)zLevel).func_181666_a(c1[0], c1[1], c1[2], c1[3]).func_181675_d();
        wr.func_181662_b((double)(renderBaseX + renderWidth), (double)renderAffectedY, (double)zLevel).func_181666_a(c2[0], c2[1], c2[2], c2[3]).func_181675_d();
        wr.func_181662_b((double)(renderBaseX + renderWidth), (double)(renderAffectedY + renderHeight), (double)zLevel).func_181666_a(c3[0], c3[1], c3[2], c3[3]).func_181675_d();
        wr.func_181662_b((double)renderBaseX, (double)(renderAffectedY + renderHeight), (double)zLevel).func_181666_a(c4[0], c4[1], c4[2], c4[3]).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        if (this.leftSided) {
            renderWidth *= -1;
        }
        int n = titleYoffset = this.title.isEmpty() ? 3 : 12;
        if (this.doneExpanding) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(renderBaseX + (this.leftSided ? -renderWidth : 16)), (float)renderAffectedY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.textSize, (float)this.textSize, (float)this.textSize);
            GlStateManager.func_179109_b((float)(-renderBaseX - (this.leftSided ? -renderWidth : 16)), (float)(-renderAffectedY), (float)0.0f);
            if (!this.title.isEmpty()) {
                fontRenderer.func_175063_a(this.title, (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + 2), 0xFFFF00);
            }
            for (int i = this.curScroll; i < this.textList.size() && i < this.curScroll + 12; ++i) {
                if (this.textList.get(i).contains("\u00a70") || this.textList.get(i).contains(TextFormatting.DARK_RED.toString())) {
                    fontRenderer.func_78276_b(this.textList.get(i), renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset, 0xFFFFFF);
                    continue;
                }
                fontRenderer.func_175063_a(this.textList.get(i), (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset), 0xFFFFFF);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (float)(renderAffectedY + (titleYoffset - 10)), (float)0.0f);
            GlStateManager.func_179098_w();
            for (IGuiWidget widget : this.widgets) {
                widget.render(mouseX - renderBaseX, mouseY - renderAffectedY, partialTicks);
            }
            GlStateManager.func_179121_F();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render((Gui)this.gui, renderBaseX, renderAffectedY, this.leftSided);
        }
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0) {
            this.isClicked = !this.isClicked;
            this.listener.actionPerformed(this);
        }
        mouseX -= this.baseX;
        mouseY -= this.affectedY;
        for (IGuiWidget widget : this.widgets) {
            if (widget.getBounds().contains(mouseX, mouseY)) {
                widget.onMouseClicked(mouseX, mouseY, button);
                this.isClicked = true;
                continue;
            }
            widget.onMouseClickedOutsideBounds(mouseX, mouseY, button);
        }
    }

    @Override
    public void onMouseClickedOutsideBounds(int mouseX, int mouseY, int button) {
    }

    @Override
    public void closeWindow() {
        this.isClicked = false;
    }

    @Override
    public void openWindow() {
        this.isClicked = true;
    }

    @Override
    public boolean isClicked() {
        return this.isClicked;
    }

    @Override
    public int getAffectedY() {
        return this.affectedY;
    }

    @Override
    public int getBaseX() {
        return this.baseX;
    }

    @Override
    public int getBaseY() {
        return this.baseY;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setBaseY(int y) {
        this.baseY = y;
    }

    @Override
    public void setTitle(String title) {
        this.title = I18n.func_135052_a((String)title, (Object[])new Object[0]);
    }

    @Override
    public boolean isDoneExpanding() {
        return this.doneExpanding;
    }

    @Override
    public void setBaseX(int x) {
        this.baseX = x;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.baseX - (this.leftSided ? this.width : 0), this.affectedY, this.width, this.height);
    }

    @Override
    public void setListener(IWidgetListener gui) {
        this.listener = gui;
    }

    @Override
    public int getID() {
        return -1;
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        this.isClicked = !this.isClicked;
        this.listener.actionPerformed(widget);
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
        this.listener.onKeyTyped(widget);
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTooltip, boolean shiftPressed) {
        if (this.mouseIsHoveringOverIcon(mouseX, mouseY)) {
            curTooltip.add(this.title);
        }
        for (IGuiWidget widget : this.widgets) {
            if (!this.isMouseOverWidget(widget, mouseX, mouseY)) continue;
            widget.addTooltip(mouseX, mouseY, curTooltip, shiftPressed);
        }
    }

    private boolean mouseIsHoveringOverIcon(int x, int y) {
        if (this.leftSided) {
            return x <= this.baseX && x >= this.baseX - 16 && y >= this.affectedY && y <= this.affectedY + 16;
        }
        return x >= this.baseX && x <= this.baseX + 16 && y >= this.affectedY && y <= this.affectedY + 16;
    }

    @Override
    public boolean onKey(char key, int keyCode) {
        for (IGuiWidget widget : this.widgets) {
            if (!widget.onKey(key, keyCode)) continue;
            return true;
        }
        return false;
    }

    private boolean isMouseOverWidget(IGuiWidget widget, int mouseX, int mouseY) {
        Rectangle rect = this.getBounds();
        return widget.getBounds().contains(mouseX -= rect.x, mouseY -= rect.y);
    }

    @Override
    public void handleMouseInput() {
        if (this.getBounds().contains(this.lastMouseX, this.lastMouseY)) {
            this.handleMouseWheel(Mouse.getDWheel());
        }
    }

    public boolean handleMouseWheel(int mouseWheel) {
        for (IGuiWidget widget : this.widgets) {
            widget.handleMouseInput();
            if (widget.getID() != -1000) continue;
            int wheel = -mouseWheel;
            wheel = MathHelper.func_76125_a((int)wheel, (int)-1, (int)1);
            ((WidgetVerticalScrollbar)widget).currentScroll += (float)wheel / (float)(this.textList.size() - 12);
            return true;
        }
        return false;
    }

    @Override
    public void postRender(int mouseX, int mouseY, float partialTick) {
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public void setTexture(ResourceLocation texture) {
        this.statIcon = StatIcon.of(texture);
    }

    public void setTexture(ItemStack itemStack) {
        this.statIcon = StatIcon.of(itemStack);
    }

    public static class StatIcon {
        public static final StatIcon NONE = new StatIcon(ItemStack.field_190927_a, null);
        private final ItemStack stack;
        private final ResourceLocation texture;

        private StatIcon(ItemStack stack, ResourceLocation texture) {
            this.stack = stack;
            this.texture = texture;
        }

        public static StatIcon of(ItemStack stack) {
            return new StatIcon(stack, null);
        }

        public static StatIcon of(Item item) {
            return new StatIcon(new ItemStack(item, 1, 0), null);
        }

        public static StatIcon of(ResourceLocation texture) {
            return new StatIcon(ItemStack.field_190927_a, texture);
        }

        void render(Gui gui, int x, int y, boolean leftSided) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            if (this.texture != null) {
                GuiPneumaticContainerBase.drawTexture(this.texture, x - (leftSided ? 16 : 0), y);
            } else if (!this.stack.func_190926_b() && gui != null || !(this.stack.func_77973_b() instanceof ItemBlock)) {
                RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
                renderItem.field_77023_b = 1.0f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-50.0f);
                GlStateManager.func_179091_B();
                RenderHelper.func_74520_c();
                renderItem.func_180450_b(this.stack, x - (leftSided ? 16 : 0), y);
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
                GlStateManager.func_179121_F();
                GlStateManager.func_179141_d();
            }
            GlStateManager.func_179084_k();
        }
    }
}

