/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.init.ModItems;
import xreliquary.util.potions.XRPotionHelper;

public class EntityXRTippedArrow
extends EntityArrow {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityTippedArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private List<PotionEffect> effects = Lists.newArrayList();

    public EntityXRTippedArrow(World worldIn) {
        super(worldIn);
    }

    public EntityXRTippedArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityXRTippedArrow(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
    }

    public void setPotionEffect(ItemStack stack) {
        this.effects = XRPotionHelper.getPotionEffectsFromStack(stack);
        this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a(this.effects));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.effects.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.effects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)0);
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.getColor();
        if (i != 0 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        XRPotionHelper.addPotionEffectsToCompoundTag(compound, this.effects);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.effects = XRPotionHelper.getPotionEffectsFromCompoundTag(compound);
        if (!this.effects.isEmpty()) {
            this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a(this.effects));
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        XRPotionHelper.applyEffectsToEntity(this.effects, (Entity)this, this.field_70250_c, living);
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        if (this.effects.isEmpty()) {
            return new ItemStack(Items.field_151032_g);
        }
        ItemStack itemstack = new ItemStack((Item)ModItems.tippedArrow);
        XRPotionHelper.addPotionEffectsToStack(itemstack, this.effects);
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i > 0) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }
}

