/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.module.features;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.base.IRegisterModel;
import com.valkyrieofnight.vlib.core.block.IRegisterItemBlock;
import com.valkyrieofnight.vlib.core.block.color.IBlockColored;
import com.valkyrieofnight.vlib.core.item.color.IItemColored;
import com.valkyrieofnight.vlib.core.registry.VLRegistryClient;
import com.valkyrieofnight.vlib.core.registry.VLRegistryCommon;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.module.features.FeatureConfigurable;
import com.valkyrieofnight.vlib.module.interfaces.IClientInit;
import com.valkyrieofnight.vlib.module.interfaces.ICommonInit;
import com.valkyrieofnight.vlib.module.interfaces.ICommonInitPost;
import com.valkyrieofnight.vlib.module.interfaces.ICommonInitPre;
import com.valkyrieofnight.vlib.module.interfaces.IEventRegisterBlocks;
import com.valkyrieofnight.vlib.module.interfaces.IEventRegisterItems;
import com.valkyrieofnight.vlib.module.interfaces.IEventRegisterModels;
import com.valkyrieofnight.vlib.module.interfaces.IRegisterOre;
import com.valkyrieofnight.vlib.module.interfaces.IRegisterTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class FeatureBlocks
extends FeatureConfigurable
implements IClientInit,
ICommonInitPre,
ICommonInit,
ICommonInitPost,
IEventRegisterBlocks,
IEventRegisterItems,
IEventRegisterModels {
    private List<Block> BLOCKS = Lists.newArrayList();
    private VLRegistryCommon REG = VLRegistryCommon.getInstance();

    public FeatureBlocks(String id) {
        super(id);
    }

    protected final void addBlock(Block blk) {
        if (blk == null) {
            return;
        }
        this.BLOCKS.add(blk);
    }

    @Override
    public void registerEventModels(ModelRegistryEvent event, IConfig config) {
        this.BLOCKS.forEach(blk -> {
            if (blk instanceof IRegisterModel) {
                ((IRegisterModel)blk).registerModel(event, VLRegistryClient.getInstance());
            }
        });
    }

    @Override
    public void registerEventItems(RegistryEvent.Register<Item> event, IConfig config) {
        IForgeRegistry reg = event.getRegistry();
        ArrayList ibl = Lists.newArrayList();
        this.BLOCKS.forEach(blk -> {
            if (blk instanceof IRegisterItemBlock) {
                IRegisterItemBlock blk2 = (IRegisterItemBlock)blk;
                ibl.add(blk2.getItemBlock());
            } else {
                ItemBlock ib = new ItemBlock(blk);
                ib.setRegistryName(blk.getRegistryName());
                ibl.add(ib);
            }
        });
        ibl.forEach(ib -> reg.register((IForgeRegistryEntry)ib));
    }

    @Override
    public void registerEventBlocks(RegistryEvent.Register<Block> event, IConfig config) {
        IForgeRegistry reg = event.getRegistry();
        this.BLOCKS.forEach(blk -> reg.register((IForgeRegistryEntry)blk));
    }

    @Override
    public void commonInitPost(FMLPostInitializationEvent event, IConfig config) {
        this.BLOCKS.forEach(blk -> {});
    }

    @Override
    public void commonInit(FMLInitializationEvent event, IConfig config) {
        this.BLOCKS.forEach(blk -> {
            if (blk instanceof IRegisterOre) {
                ((IRegisterOre)blk).registerOre(VLRegistryCommon.getInstance());
            }
        });
    }

    @Override
    public void commonInitPre(FMLPreInitializationEvent event, IConfig config) {
        this.BLOCKS.forEach(blk -> {
            if (blk instanceof IRegisterTile) {
                ((IRegisterTile)blk).registerTile(this.REG);
            }
        });
    }

    @Override
    public void clientInit(FMLInitializationEvent event, IConfig config) {
        this.BLOCKS.forEach(blk -> {
            if (blk instanceof IBlockColored) {
                IBlockColored ibc = (IBlockColored)blk;
                ItemBlock ib = ibc.getItemBlock();
                if (ib instanceof IItemColored) {
                    VLRegistryClient.registerColoredBlock(blk);
                    VLRegistryClient.registerColoredItem((Item)ib);
                } else {
                    try {
                        throw new Exception("Attempted to register ItemBlock as colored: Please implement IItemColored with your ItemBlock");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

