/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.tatw.ic2usesfe.item;

import aroma1997.tatw.Config;
import ic2.api.item.ElectricItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCapItemImpl
implements IEnergyStorage,
ICapabilityProvider {
    private final ItemStack stack;

    public EnergyCapItemImpl(ItemStack stack) {
        this.stack = stack;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive() || Config.isTatwObject(ElectricItem.getBackupManager((ItemStack)this.stack))) {
            return 0;
        }
        return (int)Math.ceil(ElectricItem.manager.charge(this.stack, (double)((float)maxReceive * Config.euPerRf), Integer.MAX_VALUE, true, simulate) / (double)Config.euPerRf);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract() || Config.isTatwObject(ElectricItem.getBackupManager((ItemStack)this.stack))) {
            return 0;
        }
        return (int)Math.floor(ElectricItem.manager.discharge(this.stack, (double)((float)maxExtract * Config.rfPerEu), 1, true, true, simulate) / (double)Config.rfPerEu);
    }

    public int getEnergyStored() {
        if (Config.isTatwObject(ElectricItem.getBackupManager((ItemStack)this.stack))) {
            return 0;
        }
        return (int)(ElectricItem.manager.getCharge(this.stack) * (double)Config.rfPerEu);
    }

    public int getMaxEnergyStored() {
        if (Config.isTatwObject(ElectricItem.getBackupManager((ItemStack)this.stack))) {
            return 0;
        }
        double stored = ElectricItem.manager.getCharge(this.stack);
        double limit = ElectricItem.manager.getMaxCharge(this.stack);
        return (int)(stored * (double)Config.rfPerEu + (limit - stored) / (double)Config.euPerRf);
    }

    public boolean canExtract() {
        return this.stack.func_190926_b() ? false : Config.contains(Config.OverrideType.IC2ItemsProduceFE, this.stack.func_77973_b().getClass());
    }

    public boolean canReceive() {
        return this.stack.func_190926_b() ? false : Config.contains(Config.OverrideType.IC2ItemsUseFE, this.stack.func_77973_b().getClass());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)this;
        }
        return null;
    }
}

