/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.tatw.ic2usesfe.block;

import aroma1997.tatw.Config;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.IEnergyNetEventReceiver;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ICSourceEventListener
implements IEnergyNetEventReceiver {
    private Set<IEnergySource> tiles = Collections.newSetFromMap(new IdentityHashMap());

    public ICSourceEventListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onAdd(IEnergyTile tile) {
        if (tile instanceof IEnergySource) {
            this.tiles.add((IEnergySource)tile);
        }
        World world = EnergyNet.instance.getWorld(tile);
        BlockPos pos = EnergyNet.instance.getPos(tile);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            world.func_175685_c(pos, world.func_180495_p(pos).func_177230_c(), true);
        }
    }

    public void onRemove(IEnergyTile tile) {
        this.tiles.remove(tile);
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            this.tiles.clear();
        } else {
            HashSet<IEnergySource> toRemove = new HashSet<IEnergySource>();
            for (IEnergySource source : this.tiles) {
                if (EnergyNet.instance.getWorld((IEnergyTile)source) != event.getWorld()) continue;
                toRemove.add(source);
            }
            this.tiles.removeAll(toRemove);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            block0: for (IEnergySource source : this.tiles) {
                World world = EnergyNet.instance.getWorld((IEnergyTile)source);
                List nextTiles = source instanceof IMetaDelegate ? ((IMetaDelegate)source).getSubTiles() : Collections.singletonList(source);
                Collections.shuffle(nextTiles);
                block1: for (IEnergyTile tile : nextTiles) {
                    IEnergySource acceptor = tile instanceof IEnergyEmitter ? (IEnergyEmitter)tile : source;
                    BlockPos pos = EnergyNet.instance.getPos(tile);
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        TileEntity te;
                        if (!acceptor.emitsEnergyTo(null, side) || EnergyNet.instance.getSubTile(world, pos) != null || (te = world.func_175625_s(pos.func_177972_a(side))) == null || !te.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) continue;
                        IEnergyStorage rec = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
                        int provide = (int)(source.getOfferedEnergy() * (double)Config.rfPerEu);
                        if (provide <= 0) continue block1;
                        int accepted = rec.receiveEnergy(provide, true);
                        if (accepted <= 0) continue;
                        accepted = rec.receiveEnergy(accepted, false);
                        source.drawEnergy((double)((float)accepted / Config.rfPerEu));
                        continue block0;
                    }
                }
            }
        }
    }
}

