/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.tatw.ic2usesfe.block;

import aroma1997.tatw.Config;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class EnergyCapImpl
implements net.minecraftforge.energy.IEnergyStorage {
    private TileEntity te;
    private EnumFacing from;

    public EnergyCapImpl(TileEntity te, EnumFacing side) {
        this.te = te;
        this.from = side;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        IEnergySink sink = this.getSink();
        if (sink == null) {
            return 0;
        }
        IEnergyAcceptor acceptor = this.getAcceptor();
        if (!acceptor.acceptsEnergyFrom(null, this.from)) {
            return 0;
        }
        maxReceive = Math.min(maxReceive, (int)(sink.getDemandedEnergy() / (double)Config.euPerRf));
        if (simulate) {
            return maxReceive;
        }
        return maxReceive - (int)(sink.injectEnergy(this.from, (double)((float)maxReceive * Config.euPerRf), 1.0) / (double)Config.euPerRf);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        IEnergySource source = this.getSource();
        if (source == null) {
            return 0;
        }
        IEnergyEmitter emitter = this.getEmitter();
        if (!emitter.emitsEnergyTo(null, this.from)) {
            return 0;
        }
        maxExtract = Math.min(maxExtract, (int)(source.getOfferedEnergy() * (double)Config.rfPerEu));
        if (simulate) {
            return maxExtract;
        }
        source.drawEnergy((double)((float)maxExtract / Config.rfPerEu));
        return maxExtract;
    }

    public int getEnergyStored() {
        if (this.te instanceof IEnergyStorage) {
            return (int)((float)((IEnergyStorage)this.te).getStored() * Config.rfPerEu);
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        if (this.te instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)this.te;
            return (int)((float)storage.getStored() * Config.rfPerEu + (float)(storage.getCapacity() - storage.getStored()) / Config.euPerRf);
        }
        return 0;
    }

    public boolean canExtract() {
        IEnergyEmitter emitter = this.getEmitter();
        return emitter != null && emitter.emitsEnergyTo(null, this.from);
    }

    public boolean canReceive() {
        IEnergyAcceptor acceptor = this.getAcceptor();
        return acceptor != null && acceptor.acceptsEnergyFrom(null, this.from);
    }

    private IEnergyAcceptor getAcceptor() {
        IEnergyTile tile = this.getSubTile();
        if (tile instanceof IEnergyAcceptor) {
            return (IEnergyAcceptor)tile;
        }
        tile = this.getTile();
        if (tile instanceof IEnergyAcceptor) {
            return (IEnergyAcceptor)tile;
        }
        return null;
    }

    private IEnergySink getSink() {
        IEnergyTile tile = this.getTile();
        if (tile instanceof IEnergySink) {
            return (IEnergySink)tile;
        }
        return null;
    }

    private IEnergyEmitter getEmitter() {
        IEnergyTile tile = this.getSubTile();
        if (tile instanceof IEnergyEmitter) {
            return (IEnergyEmitter)tile;
        }
        tile = this.getTile();
        if (tile instanceof IEnergyEmitter) {
            return (IEnergyEmitter)tile;
        }
        return null;
    }

    private IEnergySource getSource() {
        IEnergyTile tile = this.getTile();
        if (tile instanceof IEnergySource) {
            return (IEnergySource)tile;
        }
        return null;
    }

    private IEnergyTile getTile() {
        if (this.te.func_145831_w().field_72995_K) {
            return null;
        }
        IEnergyTile tile = EnergyNet.instance.getTile(this.te.func_145831_w(), this.te.func_174877_v());
        if (Config.isTatwObject(tile)) {
            return null;
        }
        return tile;
    }

    private IEnergyTile getSubTile() {
        if (this.te.func_145831_w().field_72995_K) {
            return null;
        }
        IEnergyTile tile = EnergyNet.instance.getSubTile(this.te.func_145831_w(), this.te.func_174877_v());
        if (Config.isTatwObject(tile)) {
            return null;
        }
        return tile;
    }
}

