/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.tatw.feuseseu.item;

import aroma1997.tatw.Config;
import ic2.api.item.IBackupElectricItemManager;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyItemImpl
implements IBackupElectricItemManager {
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (stack == null || !this.canReceive(stack.func_77973_b())) {
            return 0.0;
        }
        IEnergyStorage storage = this.getCap(stack);
        if (storage == null || !storage.canReceive()) {
            return 0.0;
        }
        return (float)storage.receiveEnergy((int)(amount * (double)Config.rfPerEu), simulate) / Config.rfPerEu;
    }

    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (stack == null || !this.canSend(stack.func_77973_b())) {
            return 0.0;
        }
        IEnergyStorage storage = this.getCap(stack);
        if (storage == null || !storage.canExtract()) {
            return 0.0;
        }
        return (float)storage.extractEnergy((int)Math.ceil(amount / (double)Config.euPerRf), simulate) * Config.euPerRf;
    }

    public double getCharge(ItemStack stack) {
        if (stack == null) {
            return 0.0;
        }
        IEnergyStorage storage = this.getCap(stack);
        if (storage == null) {
            return 0.0;
        }
        double average = (Config.euPerRf + 1.0f / Config.rfPerEu) / 2.0f;
        return (double)storage.getEnergyStored() * average;
    }

    public double getMaxCharge(ItemStack stack) {
        if (stack == null) {
            return 0.0;
        }
        IEnergyStorage storage = this.getCap(stack);
        if (storage == null) {
            return 0.0;
        }
        double average = (Config.euPerRf + 1.0f / Config.rfPerEu) / 2.0f;
        return (double)storage.getMaxEnergyStored() * average;
    }

    public boolean canUse(ItemStack stack, double amount) {
        return this.discharge(stack, amount, Integer.MAX_VALUE, true, false, true) >= Math.floor(amount);
    }

    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        if (!this.canUse(stack, amount)) {
            return false;
        }
        this.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
        return true;
    }

    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
    }

    public String getToolTip(ItemStack stack) {
        return Util.toSiString((double)this.getCharge(stack), (int)1) + "EU / " + Util.toSiString((double)this.getMaxCharge(stack), (int)1) + "EU";
    }

    public int getTier(ItemStack stack) {
        return 1;
    }

    public boolean handles(ItemStack stack) {
        if (StackUtil.isEmpty((ItemStack)stack)) {
            return false;
        }
        IEnergyStorage storage = this.getCap(stack);
        if (storage == null) {
            return false;
        }
        return this.canReceive(stack.func_77973_b()) || this.canSend(stack.func_77973_b());
    }

    private boolean canReceive(Item item) {
        return item == null ? false : Config.contains(Config.OverrideType.FEItemsUseEU, item.getClass());
    }

    private boolean canSend(Item item) {
        return item == null ? false : Config.contains(Config.OverrideType.FEItemsProduceEU, item.getClass());
    }

    private IEnergyStorage getCap(ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (Config.isTatwObject(storage)) {
                return null;
            }
            return storage;
        }
        return null;
    }
}

