/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.tatw.feuseseu.block;

import aroma1997.core.coremod.MCPNames;
import aroma1997.tatw.Config;
import aroma1997.tatw.feuseseu.block.ModifyList;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.IEnergyNet;
import ic2.api.energy.IEnergyNetEventReceiver;
import ic2.api.energy.NodeStats;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.info.ILocatable;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class FETileEventListener {
    private Map<TileEntity, IEnergyTile> tes = new IdentityHashMap<TileEntity, IEnergyTile>();
    private Set<TileEntity> firsttick = Collections.newSetFromMap(new IdentityHashMap());

    public FETileEventListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        final IEnergyNet parentNet = EnergyNet.instance;
        EnergyNet.instance = new IEnergyNet(){

            public void unregisterEventReceiver(IEnergyNetEventReceiver receiver) {
                parentNet.unregisterEventReceiver(receiver);
            }

            public void removeTile(IEnergyTile tile) {
                parentNet.removeTile(tile);
            }

            public void registerEventReceiver(IEnergyNetEventReceiver receiver) {
                parentNet.registerEventReceiver(receiver);
            }

            public World getWorld(IEnergyTile tile) {
                return parentNet.getWorld(tile);
            }

            public IEnergyTile getTile(World world, BlockPos pos) {
                return parentNet.getTile(world, pos);
            }

            public int getTierFromPower(double power) {
                return parentNet.getTierFromPower(power);
            }

            public IEnergyTile getSubTile(World world, BlockPos pos) {
                return parentNet.getSubTile(world, pos);
            }

            public double getPowerFromTier(int tier) {
                return parentNet.getPowerFromTier(tier);
            }

            public BlockPos getPos(IEnergyTile tile) {
                return parentNet.getPos(tile);
            }

            public NodeStats getNodeStats(IEnergyTile tile) {
                return parentNet.getNodeStats(tile);
            }

            public boolean dumpDebugInfo(World world, BlockPos pos, PrintStream console, PrintStream chat) {
                return parentNet.dumpDebugInfo(world, pos, console, chat);
            }

            public <T extends ILocatable & IEnergyTile> void addTile(T tile) {
                FETileEventListener.this.onAddPre(tile);
                parentNet.addTile(tile);
            }

            public <T extends TileEntity> void addTile(T tile) {
                FETileEventListener.this.onAddPre((IEnergyTile)tile);
                parentNet.addTile(tile);
            }
        };
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            ModifyList<TileEntity> list = new ModifyList<TileEntity>(world.field_147482_g){

                @Override
                protected void onAdd(TileEntity element) {
                    if (!Config.contains(Config.OverrideType.FEMachinesProduceEU, element.getClass()) && !Config.contains(Config.OverrideType.FEMachinesUseEU, element.getClass())) {
                        return;
                    }
                    if (!FETileEventListener.this.tes.containsKey(element)) {
                        FETileEventListener.this.firsttick.add(element);
                    }
                }

                @Override
                protected void onRemove(Object element) {
                    if (element instanceof TileEntity) {
                        IEnergyTile energyTile = (IEnergyTile)FETileEventListener.this.tes.remove(element);
                        if (energyTile != null) {
                            FETileEventListener.this.onRemove((TileEntity)element, energyTile);
                        }
                        FETileEventListener.this.firsttick.remove(element);
                    }
                }
            };
            ReflectionHelper.setPrivateValue(World.class, (Object)world, (Object)list, (String[])new String[]{MCPNames.field((String)"field_147482_g")});
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void worldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        for (TileEntity tileEntity : new ArrayList<TileEntity>(this.firsttick)) {
            if (tileEntity.func_145831_w() != world) continue;
            this.firsttick.remove(tileEntity);
        }
        for (Map.Entry entry : new IdentityHashMap<TileEntity, IEnergyTile>(this.tes).entrySet()) {
            if (((TileEntity)entry.getKey()).func_145831_w() != world) continue;
            this.tes.remove(entry.getKey());
            this.onRemove((TileEntity)entry.getKey(), (IEnergyTile)entry.getValue());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void tick(TickEvent.ServerTickEvent event) {
        for (TileEntity tile : new ArrayList<TileEntity>(this.tes.keySet())) {
            if (!tile.func_145837_r()) continue;
            IEnergyTile energyTile = this.tes.remove(tile);
            this.onRemove(tile, energyTile);
        }
        if (!this.firsttick.isEmpty()) {
            ArrayList<TileEntity> iterate = new ArrayList<TileEntity>(this.firsttick);
            this.firsttick.clear();
            for (TileEntity te : iterate) {
                IEnergyTile energy;
                if (EnergyNet.instance.getTile(te.func_145831_w(), te.func_174877_v()) != null || (energy = this.onFirstTick(te)) == null) continue;
                this.tes.put(te, energy);
            }
        }
    }

    protected IEnergyTile onFirstTick(TileEntity te) {
        boolean hasEnergy = false;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (!te.hasCapability(CapabilityEnergy.ENERGY, side)) continue;
            hasEnergy = true;
            break;
        }
        if (!hasEnergy) {
            return null;
        }
        EnergyTile tile = new EnergyTile(te);
        EnergyNet.instance.addTile((ILocatable)tile);
        return tile;
    }

    protected void onRemove(TileEntity te, IEnergyTile tile) {
        EnergyNet.instance.removeTile(tile);
    }

    protected boolean shouldAdd(TileEntity te) {
        return !this.tes.containsKey(te) && Config.contains(Config.OverrideType.FEMachinesProduceEU, te.getClass()) || Config.contains(Config.OverrideType.FEMachinesUseEU, te.getClass());
    }

    public void onAddPre(IEnergyTile tile) {
        if (Config.isTatwObject(tile)) {
            return;
        }
        List subTiles = tile instanceof IMetaDelegate ? ((IMetaDelegate)tile).getSubTiles() : Collections.singletonList(tile);
        for (IEnergyTile subTile : subTiles) {
            BlockPos pos;
            World world = EnergyNet.instance.getWorld(subTile);
            TileEntity te = world.func_175625_s(pos = EnergyNet.instance.getPos(subTile));
            if (te == null || !this.tes.containsKey(te)) continue;
            IEnergyTile realTile = this.tes.remove(te);
            this.onRemove(te, realTile);
        }
    }

    private static class EnergyTile
    implements IEnergySource,
    IEnergySink,
    IMultiEnergySource,
    ILocatable {
        private TileEntity tile;
        Map<EnumFacing, IEnergyStorage> storage = new EnumMap<EnumFacing, IEnergyStorage>(EnumFacing.class);

        public EnergyTile(TileEntity tile) {
            this.tile = tile;
        }

        private IEnergyStorage getStorage(EnumFacing side) {
            if (this.storage.containsKey(side)) {
                if (this.tile.hasCapability(CapabilityEnergy.ENERGY, side)) {
                    return this.storage.get(side);
                }
                this.storage.remove(side);
                return null;
            }
            if (this.tile.hasCapability(CapabilityEnergy.ENERGY, side)) {
                IEnergyStorage storage = (IEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, side);
                if (Config.isTatwObject(storage)) {
                    return null;
                }
                this.storage.put(side, storage);
                return storage;
            }
            return null;
        }

        private Collection<IEnergyStorage> getStorages() {
            return this.storage.values();
        }

        public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
            if (Config.isTatwObject(emitter) || !Config.contains(Config.OverrideType.FEMachinesUseEU, this.tile.getClass())) {
                return false;
            }
            IEnergyStorage storage = this.getStorage(side);
            if (storage == null) {
                return false;
            }
            return storage.canReceive();
        }

        public double getDemandedEnergy() {
            int amount = 0;
            for (IEnergyStorage storage : this.getStorages()) {
                if (!storage.canReceive()) continue;
                amount += storage.receiveEnergy(Integer.MAX_VALUE, true);
            }
            return (float)amount / Config.rfPerEu;
        }

        public int getSinkTier() {
            return Integer.MAX_VALUE;
        }

        public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
            int accepted = 0;
            int receiveAmount = (int)Math.floor(amount * (double)Config.rfPerEu);
            for (IEnergyStorage storage : this.getStorages()) {
                if (!storage.canReceive()) continue;
                int currentAccepted = storage.receiveEnergy(receiveAmount, false);
                accepted += currentAccepted;
                receiveAmount -= currentAccepted;
            }
            return (float)receiveAmount / Config.rfPerEu;
        }

        public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
            if (Config.isTatwObject(receiver) || !Config.contains(Config.OverrideType.FEMachinesProduceEU, this.tile.getClass())) {
                return false;
            }
            IEnergyStorage storage = this.getStorage(side);
            if (storage == null) {
                return false;
            }
            return storage.canExtract();
        }

        public double getOfferedEnergy() {
            int offered = 0;
            for (IEnergyStorage storage : this.getStorages()) {
                if (!storage.canExtract()) continue;
                offered += storage.extractEnergy(Integer.MAX_VALUE, true);
            }
            return (float)offered * Config.euPerRf;
        }

        public void drawEnergy(double amount) {
            int toExtract = (int)Math.ceil(amount / (double)Config.euPerRf);
            Collection<IEnergyStorage> storages = this.getStorages();
            for (IEnergyStorage storage : storages) {
                if (!storage.canExtract()) continue;
                toExtract -= storage.extractEnergy(toExtract, false);
            }
        }

        public int getSourceTier() {
            return 2;
        }

        public boolean sendMultipleEnergyPackets() {
            return true;
        }

        public int getMultipleEnergyPacketAmount() {
            int ret = 0;
            for (IEnergyStorage storage : this.getStorages()) {
                if (!storage.canExtract()) continue;
                ++ret;
            }
            return ret;
        }

        public BlockPos getPosition() {
            return this.tile.func_174877_v();
        }

        public World getWorldObj() {
            return this.tile.func_145831_w();
        }
    }
}

