/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.tatw;

import java.io.File;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static final String[] sinkOverrides = new String[]{"ic2.core.block.heatgenerator.tileentity.TileEntityElectricHeatGenerator", "ic2.core.block.kineticgenerator.tileentity.TileEntityElectricKineticHeatGenerator", "ic2.core.block.machine.tileentity.TileEntityElectricMachine", "ic2.core.block.machine.tileentity.TileEntityTesla", "ic2.core.block.wiring.TileEntityElectricBlock", "ic2.core.block.wiring.TileEntityTransformer"};
    private static final String[] sourceOverrides = new String[]{"ic2.core.block.generator.tileentity.TileEntityBaseGenerator", "ic2.core.block.generator.tileentity.TileEntityCreativeGenerator", "ic2.core.block.generator.tileentity.TileEntityGeoGenerator", "ic2.core.block.generator.tileentity.TileEntityKineticGenerator", "ic2.core.block.generator.tileentity.TileEntitySemifluidGenerator", "ic2.core.block.generator.tileentity.TileEntityStirlingGenerator", "ic2.core.block.wiring.TileEntityElectricBlock", "ic2.core.block.wiring.TileEntityTransformer", "ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric", "ic2.core.block.reactor.tileentity.TileEntityReactorChamberElectric"};
    private static final String[] sinkItemOverrides = new String[]{"ic2.core.item.ItemIC2", "ic2.core.item.armor.ItemArmorElectric", "ic2.core.item.tool.ItemElectricTool"};
    private static final String[] sourceItemOverrides = new String[]{"ic2.core.item.ItemIC2", "ic2.core.item.armor.ItemArmorElectric", "ic2.core.item.tool.ItemElectricTool"};
    private static final String[] feAcceptorOverrides = new String[]{"net.minecraft.tileentity.TileEntity"};
    private static final String[] feEmitterOverrides = new String[]{"net.minecraft.tileentity.TileEntity"};
    private static final String[] feItemAcceptorOverrides = new String[]{"net.minecraft.item.Item"};
    private static final String[] feItemEmitterOverrides = new String[]{"net.minecraft.item.Item"};
    private static EnumMap<OverrideType, Map<String, Boolean>> affectedMap = new EnumMap(OverrideType.class);
    private static EnumSet<OverrideType> enabledOverrides = EnumSet.noneOf(OverrideType.class);
    public static float euPerRf = 0.25f;
    public static float rfPerEu = 4.0f;
    private static final String overrides = "Overrides";
    private static final String overridesEnabled = "Overrides Enabled";
    private static final String ratios = "Ratios";

    static void load(File file) {
        Configuration conf = new Configuration(file);
        conf.load();
        conf.addCustomCategoryComment(overrides, "TileEntity and Item Classes being marked here will be made ForgeEnergy compatible. Note: It is possible, to add net.minecraft.tileentity.TileEntity or net.minecraft.item.Item here.");
        for (OverrideType type : OverrideType.values()) {
            Config.buildMapFull(conf, type);
            if (!conf.getBoolean(type.name(), overridesEnabled, true, "")) continue;
            enabledOverrides.add(type);
        }
        conf.addCustomCategoryComment(ratios, "Ratios to be used when converting in between Energy Units.");
        euPerRf = conf.getFloat("euPerFe", ratios, euPerRf, 0.0f, Float.MAX_VALUE, "How many FE are generated per EU.");
        rfPerEu = conf.getFloat("fePerEu", ratios, rfPerEu, 0.0f, Float.MAX_VALUE, "How many EU are generated per FE.");
        if (conf.hasChanged()) {
            conf.save();
        }
    }

    private static void buildMapFull(Configuration conf, OverrideType type) {
        String[] actualOverrides = conf.getStringList("" + (Object)((Object)type), overrides, type.defaultOverrides, type.comment);
        Config.buildMap(type, actualOverrides);
    }

    private static void buildMap(OverrideType type, String[] types) {
        Map<String, Boolean> isAffected = affectedMap.get((Object)type);
        if (isAffected == null) {
            isAffected = new HashMap<String, Boolean>();
            affectedMap.put(type, isAffected);
        }
        for (String current : types) {
            isAffected.put(current, true);
        }
    }

    public static boolean contains(OverrideType type, Class<?> clazz) {
        if (clazz == Object.class || clazz == null) {
            return false;
        }
        Map<String, Boolean> isAffected = affectedMap.get((Object)type);
        if (isAffected == null) {
            return false;
        }
        Boolean val = isAffected.get(clazz.getName());
        if (val == null) {
            val = Config.contains(type, clazz.getSuperclass());
            isAffected.put(clazz.getName(), val);
        }
        return val;
    }

    public static Iterator<String> getAffectedClasses(OverrideType type) {
        final Map<String, Boolean> isAffected = affectedMap.get((Object)type);
        if (isAffected == null) {
            return Collections.emptyIterator();
        }
        return new Iterator<String>(){
            Iterator<Map.Entry<String, Boolean>> other;
            String cached;
            {
                this.other = isAffected.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.cached != null) {
                    return true;
                }
                while (this.other.hasNext()) {
                    Map.Entry<String, Boolean> current = this.other.next();
                    if (!current.getValue().booleanValue()) continue;
                    this.cached = current.getKey();
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String ret = this.cached;
                this.cached = null;
                return ret;
            }
        };
    }

    public static boolean isOverrideEnabled(OverrideType type) {
        return enabledOverrides.contains((Object)type);
    }

    public static boolean isTatwObject(Object o) {
        return o != null && o.getClass().getName().startsWith("aroma1997.tatw");
    }

    static /* synthetic */ String[] access$000() {
        return sinkOverrides;
    }

    static /* synthetic */ String[] access$100() {
        return sourceOverrides;
    }

    static /* synthetic */ String[] access$200() {
        return sinkItemOverrides;
    }

    static /* synthetic */ String[] access$300() {
        return sourceItemOverrides;
    }

    static /* synthetic */ String[] access$400() {
        return feAcceptorOverrides;
    }

    static /* synthetic */ String[] access$500() {
        return feEmitterOverrides;
    }

    static /* synthetic */ String[] access$600() {
        return feItemAcceptorOverrides;
    }

    static /* synthetic */ String[] access$700() {
        return feItemEmitterOverrides;
    }

    public static enum OverrideType {
        IC2MachinesUseFE("Overrides for  IC2 Energy Sinks, that should use FE", Config.access$000()),
        IC2MachinesProduceFE("Overrides for IC2 Energy Sources, that should produce FE", Config.access$100()),
        IC2ItemsUseFE("Override for IC2 Items, that should use FE", Config.access$200()),
        IC2ItemsProduceFE("Override for IC2 Items, that should produce FE", Config.access$300()),
        FEMachinesUseEU("Override for TileEntities, that should use EU", Config.access$400()),
        FEMachinesProduceEU("Overrides for TileEntities, that should produce EU", Config.access$500()),
        FEItemsUseEU("Override for Items, that should use EU", Config.access$600()),
        FEItemsProduceEU("Overrides for Items, that should produce EU", Config.access$700());

        private final String comment;
        private final String[] defaultOverrides;

        private OverrideType(String comment, String[] overrides) {
            this.comment = comment;
            this.defaultOverrides = overrides;
        }
    }
}

