/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.fx;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.psi.client.fx.FXQueued;
import vazkii.psi.client.fx.ParticleRenderDispatcher;

public class FXWisp
extends FXQueued {
    public static final ResourceLocation particles = new ResourceLocation("psi:textures/misc/wisp_large.png");
    public static final Queue<FXWisp> queuedRenders = new ArrayDeque<FXWisp>();
    public static final Queue<FXWisp> queuedDepthIgnoringRenders = new ArrayDeque<FXWisp>();
    private final boolean depthTest;
    private final float moteParticleScale;
    private final int moteHalfLife;

    public FXWisp(World world, double d, double d1, double d2, float size, float red, float green, float blue, boolean distanceLimit, boolean depthTest, float maxAgeMul) {
        super(world, d, d1, d2, size, red, green, blue, (int)(28.0 / (Math.random() * 0.3 + 0.7) * (double)maxAgeMul));
        this.moteParticleScale = this.field_70544_f;
        this.depthTest = depthTest;
        this.moteHalfLife = this.field_70547_e / 2;
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (distanceLimit) {
            int visibleDistance = 50;
            if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                visibleDistance = 25;
            }
            if (viewEntity == null || viewEntity.func_70011_f(this.field_187126_f, this.field_187127_g, this.field_187128_h) > (double)visibleDistance) {
                this.field_70547_e = 0;
            }
        }
    }

    @Override
    protected boolean hasSlowdown() {
        return true;
    }

    @Override
    protected double slowdownFactor() {
        return 0.98;
    }

    @Override
    protected boolean hasFriction() {
        return false;
    }

    @Override
    protected void addToQueue() {
        if (this.depthTest) {
            queuedRenders.add(this);
        } else {
            queuedDepthIgnoringRenders.add(this);
        }
    }

    public int getMoteHalfLife() {
        return this.moteHalfLife;
    }

    @Override
    protected void incrementQueueCount() {
        if (this.depthTest) {
            ++ParticleRenderDispatcher.wispFxCount;
        } else {
            ++ParticleRenderDispatcher.depthIgnoringWispFxCount;
        }
    }

    @Override
    protected float getScale() {
        float agescale = (float)this.field_70546_d / (float)this.moteHalfLife;
        if (agescale > 1.0f) {
            agescale = 2.0f - agescale;
        }
        this.field_70544_f = this.moteParticleScale * agescale;
        return 0.5f * this.field_70544_f;
    }

    @Override
    protected float getMinU() {
        return 0.0f;
    }

    @Override
    protected float getMaxU() {
        return 1.0f;
    }

    @Override
    protected float getMinV() {
        return 0.0f;
    }

    @Override
    protected float getMaxV() {
        return 1.0f;
    }

    public static void dispatchQueuedRenders(Tessellator tessellator) {
        ParticleRenderDispatcher.wispFxCount = 0;
        ParticleRenderDispatcher.depthIgnoringWispFxCount = 0;
        FXQueued.dispatchQueuedRenders(tessellator, particles, queuedRenders);
        GlStateManager.func_179097_i();
        FXQueued.dispatchQueuedRenders(tessellator, particles, queuedDepthIgnoringRenders);
        GlStateManager.func_179126_j();
    }
}

