/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.helper;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class SharingHelper {
    private static final String CLIENT_ID = "d5d2258f3526156";
    private static IntBuffer pixelBuffer;
    private static int[] pixelValues;

    public static void uploadAndShare(String title, String export) {
        String url = SharingHelper.uploadImage(title, export);
        try {
            String contents = "## " + title + "  \n### [Image + Code](" + url + ")\n(to get the code click the link, RES won't show it)\n\n---\n*REPLACE THIS WITH A DESCRIPTION OF YOUR SPELL  \nMake sure you read the rules before posting. Look on the sidebar: https://www.reddit.com/r/psispellcompendium/  \nDelete this part before you submit.*";
            String encodedContents = URLEncoder.encode(contents, "UTF-8");
            String encodedTitle = URLEncoder.encode(title, "UTF-8");
            String redditUrl = "https://old.reddit.com/r/psispellcompendium/submit?title=" + encodedTitle + "&text=" + encodedContents;
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(redditUrl));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void uploadAndOpen(String title, String export) {
        String url = SharingHelper.uploadImage(title, export);
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String uploadImage(String title, String export) {
        try {
            String desc = "Spell Code:\n\n" + export;
            CloseableHttpClient client = HttpClients.createDefault();
            String url = "https://api.imgur.com/3/image";
            HttpPost post = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            list.add(new BasicNameValuePair("type", "base64"));
            list.add(new BasicNameValuePair("image", SharingHelper.takeScreenshot()));
            list.add(new BasicNameValuePair("name", title));
            list.add(new BasicNameValuePair("description", desc));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            post.addHeader("Authorization", "Client-ID d5d2258f3526156");
            HttpResponse res = client.execute((HttpUriRequest)post);
            JsonObject resJson = new JsonParser().parse(EntityUtils.toString((HttpEntity)res.getEntity())).getAsJsonObject();
            if (resJson.has("success") && resJson.get("success").getAsBoolean()) {
                JsonObject data = resJson.get("data").getAsJsonObject();
                String id = data.get("id").getAsString();
                return "https://imgur.com/" + id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "N/A";
    }

    public static String takeScreenshot() throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        int screenWidth = mc.field_71443_c;
        int screenHeight = mc.field_71440_d;
        int scale = res.func_78325_e();
        int width = 380 * scale;
        int height = 200 * scale;
        int left = screenWidth / 2 - width / 2;
        int top = screenHeight / 2 - height / 2;
        int i = width * height;
        if (pixelBuffer == null || pixelBuffer.capacity() < i) {
            pixelBuffer = BufferUtils.createIntBuffer((int)i);
            pixelValues = new int[i];
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        pixelBuffer.clear();
        GL11.glReadPixels((int)left, (int)top, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        pixelBuffer.get(pixelValues);
        TextureUtil.func_147953_a((int[])pixelValues, (int)width, (int)height);
        BufferedImage bufferedimage = new BufferedImage(width, height, 1);
        bufferedimage.setRGB(0, 0, width, height, pixelValues, 0, width);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedimage, "png", stream);
        byte[] bArray = stream.toByteArray();
        return Base64.getEncoder().encodeToString(bArray);
    }
}

