/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.gui;

import info.loenwind.autoconfig.factory.FactoryManager;
import info.loenwind.autoconfig.util.Lang;
import info.loenwind.autoconfig.util.NullHelper;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ConfigElementProperty
implements IConfigElement {
    private Property prop;

    public ConfigElementProperty(Property prop) {
        this.prop = prop;
    }

    @Nullable
    public List<IConfigElement> getChildElements() {
        return null;
    }

    @Nullable
    public String getName() {
        return this.prop.getName();
    }

    public boolean isProperty() {
        return true;
    }

    @Nullable
    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return this.prop.getConfigEntryClass();
    }

    @Nullable
    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return this.prop.getArrayEntryClass();
    }

    @Nullable
    public String getQualifiedName() {
        return this.prop.getName();
    }

    public ConfigGuiType getType() {
        return ConfigElementProperty.getType(this.prop);
    }

    public static ConfigGuiType getType(Property prop) {
        switch (prop.getType()) {
            case BOOLEAN: {
                return ConfigGuiType.BOOLEAN;
            }
            case COLOR: {
                return ConfigGuiType.COLOR;
            }
            case DOUBLE: {
                return ConfigGuiType.DOUBLE;
            }
            case INTEGER: {
                return ConfigGuiType.INTEGER;
            }
            case MOD_ID: {
                return ConfigGuiType.MOD_ID;
            }
        }
        return ConfigGuiType.STRING;
    }

    public boolean isList() {
        return this.prop.isList();
    }

    public boolean isListLengthFixed() {
        return this.prop.isListLengthFixed();
    }

    public int getMaxListLength() {
        return this.prop.getMaxListLength();
    }

    public String getComment() {
        String raw = NullHelper.first(this.prop.getComment(), "").replaceFirst("\\s*\\[.*\\]", "");
        if (this.isSynced()) {
            return Lang.NETWORK_CONFIG_CONNECTED.get(raw.replace(" (synced from server)", ""));
        }
        if (raw.contains(" (must be kept in sync with server)")) {
            return Lang.NETWORK_CONFIG_OFFLINE.get(raw.replace(" (must be kept in sync with server)", ""));
        }
        if (raw.contains(" (synced from server)")) {
            return Lang.NETWORK_CONFIG_SYNC.get(raw.replace(" (synced from server)", ""));
        }
        return raw;
    }

    public boolean isDefault() {
        return this.prop.isDefault();
    }

    public void setToDefault() {
        this.prop.setToDefault();
    }

    public boolean requiresWorldRestart() {
        return this.isSynced() || this.prop.requiresWorldRestart();
    }

    protected boolean isSynced() {
        return FactoryManager.hasOverrides() && this.prop.getComment().contains(" (synced from server)");
    }

    public boolean showInGui() {
        return this.prop.showInGui() && this.prop.getComment() != null && !this.prop.getComment().trim().isEmpty();
    }

    public boolean requiresMcRestart() {
        return this.prop.requiresMcRestart();
    }

    @Nullable
    public String[] getValidValues() {
        return this.prop.getValidValues();
    }

    @Nullable
    public String getLanguageKey() {
        return this.prop.getLanguageKey();
    }

    @Nullable
    public Object getDefault() {
        return this.prop.getDefault();
    }

    @Nullable
    public Object[] getDefaults() {
        Object[] aVal = this.prop.getDefaults();
        if (this.prop.getType() == Property.Type.BOOLEAN) {
            Object[] ba = new Boolean[aVal.length];
            for (int i = 0; i < aVal.length; ++i) {
                ba[i] = Boolean.valueOf((String)aVal[i]);
            }
            return ba;
        }
        if (this.prop.getType() == Property.Type.DOUBLE) {
            Object[] da = new Double[aVal.length];
            for (int i = 0; i < aVal.length; ++i) {
                da[i] = Double.valueOf(((String)aVal[i]).toString());
            }
            return da;
        }
        if (this.prop.getType() == Property.Type.INTEGER) {
            Object[] ia = new Integer[aVal.length];
            for (int i = 0; i < aVal.length; ++i) {
                ia[i] = Integer.valueOf(((String)aVal[i]).toString());
            }
            return ia;
        }
        return aVal;
    }

    @Nullable
    public Pattern getValidationPattern() {
        return this.prop.getValidationPattern();
    }

    @Nullable
    public Object get() {
        return this.prop.getString();
    }

    @Nullable
    public Object[] getList() {
        Object[] aVal = this.prop.getStringList();
        if (this.prop.getType() == Property.Type.BOOLEAN) {
            Object[] ba = new Boolean[aVal.length];
            for (int i = 0; i < aVal.length; ++i) {
                ba[i] = Boolean.valueOf((String)aVal[i]);
            }
            return ba;
        }
        if (this.prop.getType() == Property.Type.DOUBLE) {
            Object[] da = new Double[aVal.length];
            for (int i = 0; i < aVal.length; ++i) {
                da[i] = Double.valueOf(((String)aVal[i]).toString());
            }
            return da;
        }
        if (this.prop.getType() == Property.Type.INTEGER) {
            Object[] ia = new Integer[aVal.length];
            for (int i = 0; i < aVal.length; ++i) {
                ia[i] = Integer.valueOf(((String)aVal[i]).toString());
            }
            return ia;
        }
        return aVal;
    }

    public void set(@Nullable Object value) {
        if (value != null) {
            if (this.prop.getType() == Property.Type.BOOLEAN) {
                this.prop.set(Boolean.parseBoolean(value.toString()));
            } else if (this.prop.getType() == Property.Type.DOUBLE) {
                this.prop.set(Double.parseDouble(value.toString()));
            } else if (this.prop.getType() == Property.Type.INTEGER) {
                this.prop.set(Integer.parseInt(value.toString()));
            } else {
                this.prop.set(value.toString());
            }
        }
    }

    public void set(@Nullable Object[] aVal) {
        if (aVal != null) {
            if (this.prop.getType() == Property.Type.BOOLEAN) {
                boolean[] ba = new boolean[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    ba[i] = Boolean.valueOf(aVal[i].toString());
                }
                this.prop.set(ba);
            } else if (this.prop.getType() == Property.Type.DOUBLE) {
                double[] da = new double[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    da[i] = Double.valueOf(aVal[i].toString());
                }
                this.prop.set(da);
            } else if (this.prop.getType() == Property.Type.INTEGER) {
                int[] ia = new int[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    ia[i] = Integer.valueOf(aVal[i].toString());
                }
                this.prop.set(ia);
            } else {
                String[] is = new String[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    is[i] = aVal[i].toString();
                }
                this.prop.set(is);
            }
        }
    }

    @Nullable
    public Object getMinValue() {
        return this.prop.getMinValue();
    }

    @Nullable
    public Object getMaxValue() {
        return this.prop.getMaxValue();
    }
}

