/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.exchangebuild;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.exchangebuild.ItemBuildSwapper;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSwapBlock
implements IMessage,
IMessageHandler<PacketSwapBlock, IMessage> {
    private BlockPos pos;
    private ItemBuildSwapper.ActionType actionType;
    private ItemBuildSwapper.WandType wandType;
    private EnumFacing side;
    private EnumHand hand;

    public PacketSwapBlock() {
    }

    public PacketSwapBlock(BlockPos mouseover, EnumFacing s, ItemBuildSwapper.ActionType t, ItemBuildSwapper.WandType w, EnumHand hand) {
        this.pos = mouseover;
        this.actionType = t;
        this.wandType = w;
        this.side = s;
        this.hand = hand;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        int s = tags.func_74762_e("s");
        this.side = EnumFacing.values()[s];
        int t = tags.func_74762_e("t");
        this.actionType = ItemBuildSwapper.ActionType.values()[t];
        int w = tags.func_74762_e("w");
        this.wandType = ItemBuildSwapper.WandType.values()[w];
        int hnd = tags.func_74762_e("hand");
        this.hand = EnumHand.values()[hnd];
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("t", this.actionType.ordinal());
        tags.func_74768_a("w", this.wandType.ordinal());
        tags.func_74768_a("s", this.side.ordinal());
        tags.func_74768_a("hand", this.hand.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(final PacketSwapBlock message, final MessageContext ctx) {
        if (ctx.side.isServer() && message.pos != null) {
            ModCyclic.proxy.getThreadFromContext(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketSwapBlock.this.handle(message, ctx);
                }
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(PacketSwapBlock message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.func_130014_f_();
        IBlockState matched = null;
        if (message.wandType == ItemBuildSwapper.WandType.MATCH) {
            matched = world.func_180495_p(message.pos);
        }
        List<BlockPos> places = PacketSwapBlock.getSelectedBlocks(world, message.pos, message.actionType, message.wandType, message.side, matched);
        HashMap<BlockPos, Integer> processed = new HashMap<BlockPos, Integer>();
        try {
            List<BlockPos> list = places;
            synchronized (list) {
                for (BlockPos curPos : places) {
                    ItemStack stackBuildWith;
                    IBlockState newToPlace;
                    boolean isEmptySpot;
                    if (!processed.containsKey(curPos)) {
                        processed.put(curPos, 0);
                    }
                    if ((Integer)processed.get(curPos) > 0) continue;
                    processed.put(curPos, (Integer)processed.get(curPos) + 1);
                    int slot = UtilPlayer.getFirstSlotWithBlock((EntityPlayer)player);
                    if (slot < 0 || world.func_175625_s(curPos) != null) continue;
                    IBlockState replacedBlockState = world.func_180495_p(curPos);
                    Block replacedBlock = replacedBlockState.func_177230_c();
                    boolean bl = isEmptySpot = world.func_175623_d(curPos) || replacedBlockState == null;
                    if (isEmptySpot && message.wandType == ItemBuildSwapper.WandType.MATCH) continue;
                    String itemName = UtilItemStack.getStringForBlock(replacedBlock);
                    boolean isInBlacklist = false;
                    for (String s : ItemBuildSwapper.swapBlacklist) {
                        if (s == null || !s.equals(itemName)) continue;
                        isInBlacklist = true;
                        break;
                    }
                    if (isInBlacklist || UtilItemStack.getBlockHardness(replacedBlockState, world, curPos) < 0.0f || UtilWorld.doBlockStatesMatch(replacedBlockState, newToPlace = UtilPlayer.getBlockstateFromSlot((EntityPlayer)player, slot)) || (stackBuildWith = player.field_71071_by.func_70301_a(slot)).func_190926_b() || stackBuildWith.func_190916_E() <= 0) continue;
                    world.func_175698_g(curPos);
                    boolean success = false;
                    ItemStack itemStackHeld = player.func_184586_b(message.hand);
                    if (!success) {
                        success = UtilPlaceBlocks.placeStateSafe(world, (EntityPlayer)player, curPos, newToPlace);
                    }
                    if (success) {
                        UtilPlayer.decrStackSize((EntityPlayer)player, slot);
                    }
                    if (!success) continue;
                    world.func_175718_b(2001, curPos, Block.func_176210_f((IBlockState)replacedBlockState));
                    replacedBlock.func_180657_a(world, (EntityPlayer)player, curPos, replacedBlockState, null, itemStackHeld);
                    ItemStack held = player.func_184586_b(message.hand);
                    if (held.func_190926_b() || !(held.func_77973_b() instanceof ItemBuildSwapper)) continue;
                    UtilItemStack.damageItem((EntityPlayer)player, held);
                }
            }
        }
        catch (ConcurrentModificationException e) {
            ModCyclic.logger.error("PacketSwapBlock exception " + message.pos, e);
        }
    }

    public static List<BlockPos> getSelectedBlocks(World world, BlockPos pos, ItemBuildSwapper.ActionType actionType, ItemBuildSwapper.WandType wandType, EnumFacing side, IBlockState matched) {
        List<BlockPos> places = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n();
        int yMin = pos.func_177956_o();
        int zMin = pos.func_177952_p();
        int xMax = pos.func_177958_n();
        int yMax = pos.func_177956_o();
        int zMax = pos.func_177952_p();
        boolean isVertical = side == EnumFacing.UP || side == EnumFacing.DOWN;
        int offsetH = 0;
        int offsetW = 0;
        switch (actionType) {
            case SINGLE: {
                places.add(pos);
                offsetH = 0;
                offsetW = 0;
                break;
            }
            case X3: {
                offsetH = 1;
                offsetW = 1;
                break;
            }
            case X5: {
                offsetH = 2;
                offsetW = 2;
                break;
            }
            case X7: {
                offsetH = 3;
                offsetW = 3;
                break;
            }
            case X9: {
                offsetH = 4;
                offsetW = 4;
                break;
            }
            case X19: {
                offsetH = 0;
                offsetW = 4;
                break;
            }
            case X91: {
                offsetH = 4;
                offsetW = 0;
                break;
            }
        }
        if (actionType != ItemBuildSwapper.ActionType.SINGLE) {
            if (isVertical) {
                xMin -= offsetH;
                xMax += offsetH;
                zMin -= offsetW;
                zMax += offsetW;
            } else if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                zMin -= offsetH;
                zMax += offsetH;
                yMin -= offsetW;
                yMax += offsetW;
            } else {
                xMin -= offsetH;
                xMax += offsetH;
                yMin -= offsetW;
                yMax += offsetW;
            }
            places = UtilWorld.getPositionsInRange(pos, xMin, xMax, yMin, yMax, zMin, zMax);
        }
        ArrayList<BlockPos> retPlaces = new ArrayList<BlockPos>();
        for (BlockPos p : places) {
            if (world.func_175623_d(p) && wandType == ItemBuildSwapper.WandType.MATCH || wandType == ItemBuildSwapper.WandType.MATCH && matched != null && !UtilWorld.doBlockStatesMatch(matched, world.func_180495_p(p))) continue;
            retPlaces.add(p);
        }
        return retPlaces;
    }
}

