/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.disenchanter;

import com.google.common.collect.Maps;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.disenchanter.BlockDisenchanter;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilOreDictionary;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class TileEntityDisenchanter
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    public static int TIMER_FULL = 100;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_BOTTLE = 1;
    public static final int SLOT_REDSTONE = 2;
    public static final int SLOT_GLOWSTONE = 3;
    public static final int SLOT_BOOK = 4;

    public TileEntityDisenchanter() {
        super(14);
        this.initEnergy(new EnergyStore(64000, 64000, 64000), BlockDisenchanter.FUEL_COST);
        this.setSlotsForInsert(0, 4);
        this.setSlotsForExtract(5, 13);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77948_v() || stack.func_77973_b() == Items.field_151134_bR;
        }
        if (index == 1) {
            return stack.func_77973_b() == Items.field_151062_by;
        }
        if (index == 4) {
            return stack.func_77973_b() == Items.field_151122_aG;
        }
        if (index == 2) {
            return UtilOreDictionary.doesMatchOreDict(stack, "dustRedstone");
        }
        if (index == 3) {
            return UtilOreDictionary.doesMatchOreDict(stack, "dustGlowstone");
        }
        return super.func_94041_b(index, stack);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.isInputValid()) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        --this.timer;
        if (this.timer > 0 || this.field_145850_b.field_72995_K) {
            return;
        }
        this.timer = TIMER_FULL;
        ItemStack input = this.func_70301_a(0);
        ItemStack eBook = new ItemStack(Items.field_151134_bR);
        LinkedHashMap outEnchants = Maps.newLinkedHashMap();
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)input);
        Enchantment keyMoved = null;
        Iterator iterator = enchants.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            keyMoved = (Enchantment)entry.getKey();
            outEnchants.put(keyMoved, entry.getValue());
        }
        if (outEnchants.size() == 0 || keyMoved == null) {
            return;
        }
        enchants.remove(keyMoved);
        EnchantmentHelper.func_82782_a((Map)outEnchants, (ItemStack)eBook);
        this.dropStack(eBook);
        if (input.func_77973_b() == Items.field_151134_bR && enchants.size() == 0) {
            this.dropStack(new ItemStack(Items.field_151122_aG));
        } else if (input.func_77973_b() == Items.field_151134_bR) {
            ItemStack inputCopy = new ItemStack(Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)inputCopy);
            this.dropStack(inputCopy);
        } else {
            ModCyclic.logger.log("remaining overwrite enchants  " + enchants.size(), new Object[0]);
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)input);
            this.dropStack(input);
        }
        this.func_70299_a(0, ItemStack.field_190927_a);
        this.decrStackSize(3);
        this.decrStackSize(2);
        this.decrStackSize(1);
        this.decrStackSize(4);
        UtilSound.playSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_190021_aL, SoundCategory.BLOCKS);
    }

    private void dropStack(ItemStack stack) {
        for (int i = 5; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.func_70299_a(i, stack);
            return;
        }
        EntityItem ei = UtilItemStack.dropItemStackInWorld(this.field_145850_b, this.field_174879_c.func_177984_a(), stack);
        ei.func_70024_g(0.0, 1.0, 0.0);
    }

    private boolean isInputValid() {
        return this.func_70301_a(4).func_77973_b() == Items.field_151122_aG && this.func_70301_a(2).func_77973_b() == Items.field_151137_ax && this.func_70301_a(3).func_77973_b() == Items.field_151114_aO && this.func_70301_a(1).func_77973_b() == Items.field_151062_by && !this.func_70301_a(0).func_190926_b();
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e("redstone");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(tagCompound);
    }

    public static enum Fields {
        REDSTONE,
        TIMER;

    }
}

