/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MinionDamage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class WizardryUtilities {
    public static final EntityEquipmentSlot[] ARMOUR_SLOTS;
    private static final DataParameter<Boolean> POWERED;
    public static final double ANTI_Z_FIGHTING_OFFSET = 0.005;

    public static int getLightLevel(World world, BlockPos pos) {
        int i = world.func_175671_l(pos);
        if (world.func_72911_I()) {
            int j = world.func_175657_ab();
            world.func_175692_b(10);
            i = world.func_175671_l(pos);
            world.func_175692_b(j);
        }
        return i;
    }

    public static boolean canBlockBeReplaced(World world, BlockPos pos, boolean excludeLiquids) {
        return !(!world.func_175623_d(new BlockPos((Vec3i)pos)) && !world.func_180495_p(pos).func_185904_a().func_76222_j() || excludeLiquids && world.func_180495_p(pos).func_185904_a().func_76224_d());
    }

    public static boolean canBlockBeReplaced(World world, BlockPos pos) {
        return WizardryUtilities.canBlockBeReplaced(world, pos, false);
    }

    public static boolean isBlockUnbreakable(World world, BlockPos pos) {
        return !world.func_175623_d(new BlockPos((Vec3i)pos)) && world.func_180495_p(pos).func_185887_b(world, pos) == -1.0f;
    }

    public static IBlockState copyState(Block block, IBlockState source) {
        IBlockState state = block.func_176223_P();
        for (IProperty property : source.func_177227_a()) {
            state = state.func_177226_a(property, (Comparable)source.func_177228_b().get((Object)property));
        }
        return state;
    }

    @Nullable
    public static Integer getNearestSurface(World world, BlockPos pos, EnumFacing direction, int range, boolean doubleSided, SurfaceCriteria criteria) {
        int i;
        Integer surface = null;
        int currentBest = Integer.MAX_VALUE;
        int n = i = doubleSided ? -range : 0;
        while (i <= range && i < currentBest) {
            BlockPos testPos = pos.func_177967_a(direction, i);
            if (criteria.test(world, testPos, direction)) {
                surface = (int)WizardryUtilities.component(WizardryUtilities.getFaceCentre(testPos, direction), direction.func_176740_k());
                currentBest = Math.abs(i);
            }
            ++i;
        }
        return surface;
    }

    public static boolean isTreeBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockLog || world.func_180495_p(pos).func_177230_c() instanceof BlockCactus || world.func_180495_p(pos).func_177230_c().isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos) || world.func_180495_p(pos).func_177230_c().isFoliage((IBlockAccess)world, pos) || Arrays.asList(Wizardry.settings.treeBlocks).contains(world.func_180495_p(pos).func_177230_c().getRegistryName());
    }

    @Nullable
    public static Integer getNearestFloor(World world, BlockPos pos, int range) {
        return WizardryUtilities.getNearestSurface(world, pos, EnumFacing.UP, range, true, SurfaceCriteria.COLLIDABLE);
    }

    @Deprecated
    public static int getNearestFloorLevel(World world, BlockPos pos, int range) {
        Integer floor = WizardryUtilities.getNearestFloor(world, pos, range);
        return floor == null ? -1 : floor;
    }

    @Deprecated
    public static int getNearestFloorLevelB(World world, BlockPos pos, int range) {
        Integer floor = WizardryUtilities.getNearestSurface(world, pos, EnumFacing.UP, range, true, SurfaceCriteria.SOLID_LIQUID_TO_AIR);
        return floor == null ? -1 : floor;
    }

    @Deprecated
    public static int getNearestFloorLevelC(World world, BlockPos pos, int range) {
        Integer floor = WizardryUtilities.getNearestSurface(world, pos, EnumFacing.UP, range, true, SurfaceCriteria.NOT_AIR_TO_AIR);
        return floor == null ? -1 : floor;
    }

    @Nullable
    public static BlockPos findNearbyFloorSpace(Entity entity, int horizontalRange, int verticalRange) {
        World world = entity.field_70170_p;
        BlockPos origin = new BlockPos(entity);
        return WizardryUtilities.findNearbyFloorSpace(world, origin, horizontalRange, verticalRange);
    }

    @Nullable
    public static BlockPos findNearbyFloorSpace(World world, BlockPos origin, int horizontalRange, int verticalRange) {
        ArrayList<BlockPos> possibleLocations = new ArrayList<BlockPos>();
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                Integer y = WizardryUtilities.getNearestFloor(world, origin.func_177982_a(x, 0, z), verticalRange);
                if (y == null) continue;
                possibleLocations.add(new BlockPos(origin.func_177958_n() + x, y.intValue(), origin.func_177952_p() + z));
            }
        }
        if (possibleLocations.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleLocations.get(world.field_73012_v.nextInt(possibleLocations.size()));
    }

    public static IBlockState getBlockEntityIsStandingOn(Entity entity) {
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), (int)entity.func_174813_aQ().field_72338_b - 1, MathHelper.func_76128_c((double)entity.field_70161_v));
        return entity.field_70170_p.func_180495_p(pos);
    }

    public static List<BlockPos> getBlockSphere(BlockPos centre, double radius) {
        ArrayList<BlockPos> sphere = new ArrayList<BlockPos>((int)Math.pow(radius, 3.0));
        int i = -((int)radius);
        while ((double)i <= radius) {
            float r1 = MathHelper.func_76133_a((double)(radius * radius - (double)(i * i)));
            int j = -((int)r1);
            while ((float)j <= r1) {
                float r2 = MathHelper.func_76133_a((double)(radius * radius - (double)(i * i) - (double)(j * j)));
                int k = -((int)r2);
                while ((float)k <= r2) {
                    sphere.add(centre.func_177982_a(i, j, k));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return sphere;
    }

    public static List<EntityLivingBase> getEntitiesWithinRadius(double radius, double x, double y, double z, World world) {
        return WizardryUtilities.getEntitiesWithinRadius(radius, x, y, z, world, EntityLivingBase.class);
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(double radius, double x, double y, double z, World world, Class<T> entityType) {
        AxisAlignedBB aabb = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entityList = world.func_72872_a(entityType, aabb);
        for (int i = 0; i < entityList.size(); ++i) {
            if (!(((Entity)entityList.get(i)).func_70011_f(x, y, z) > radius)) continue;
            entityList.remove(i);
            break;
        }
        return entityList;
    }

    public static Vec3d getCentre(BlockPos pos) {
        return new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
    }

    public static Vec3d getCentre(AxisAlignedBB box) {
        return new Vec3d(box.field_72340_a + (box.field_72336_d - box.field_72340_a) * 0.5, box.field_72338_b + (box.field_72337_e - box.field_72338_b) * 0.5, box.field_72339_c + (box.field_72334_f - box.field_72339_c) * 0.5);
    }

    public static Vec3d getFaceCentre(BlockPos pos, EnumFacing face) {
        return WizardryUtilities.getCentre(pos).func_178787_e(new Vec3d(face.func_176730_m()).func_186678_a(0.5));
    }

    public static double component(Vec3d vec, EnumFacing.Axis axis) {
        return (new double[]{vec.field_72450_a, vec.field_72448_b, vec.field_72449_c})[axis.ordinal()];
    }

    public static int component(Vec3i vec, EnumFacing.Axis axis) {
        return (new int[]{vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p()})[axis.ordinal()];
    }

    public static Vec3d replaceComponent(Vec3d vec, EnumFacing.Axis axis, double newValue) {
        double[] components = new double[]{vec.field_72450_a, vec.field_72448_b, vec.field_72449_c};
        components[axis.ordinal()] = newValue;
        return new Vec3d(components[0], components[1], components[2]);
    }

    public static Vec3i replaceComponent(Vec3i vec, EnumFacing.Axis axis, int newValue) {
        int[] components = new int[]{vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p()};
        components[axis.ordinal()] = newValue;
        return new Vec3i(components[0], components[1], components[2]);
    }

    public static Vec3d[] getVertices(AxisAlignedBB box) {
        return new Vec3d[]{new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72334_f)};
    }

    public static Vec3d[] getVertices(World world, BlockPos pos) {
        return WizardryUtilities.getVertices(world.func_180495_p(pos).func_185900_c((IBlockAccess)world, pos).func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public static float getPitch(EnumFacing facing) {
        return facing == EnumFacing.UP ? 90.0f : (facing == EnumFacing.DOWN ? -90.0f : 0.0f);
    }

    @Nullable
    public static Entity getEntityByUUID(World world, @Nullable UUID id) {
        if (id == null) {
            return null;
        }
        for (Entity entity : world.field_72996_f) {
            if (!entity.func_110124_au().equals(id)) continue;
            return entity;
        }
        return null;
    }

    public static void playSoundAtPlayer(EntityPlayer player, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, category, volume, pitch);
    }

    public static void playSoundAtPlayer(EntityPlayer player, SoundEvent sound, float volume, float pitch) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, SoundCategory.PLAYERS, volume, pitch);
    }

    @Nullable
    public static Entity getRider(Entity entity) {
        return !entity.func_184188_bt().isEmpty() ? (Entity)entity.func_184188_bt().get(0) : null;
    }

    public static boolean attackEntityWithoutKnockback(Entity entity, DamageSource source, float amount) {
        double vx = entity.field_70159_w;
        double vy = entity.field_70181_x;
        double vz = entity.field_70179_y;
        boolean succeeded = entity.func_70097_a(source, amount);
        entity.field_70159_w = vx;
        entity.field_70181_x = vy;
        entity.field_70179_y = vz;
        return succeeded;
    }

    public static void applyStandardKnockback(Entity attacker, EntityLivingBase target) {
        double dx = attacker.field_70165_t - target.field_70165_t;
        double dz = attacker.field_70161_v - target.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        target.func_70653_a(attacker, 0.4f, dx, dz);
    }

    public static void undoGravity(Entity entity) {
        if (!entity.func_189652_ae()) {
            double gravity = 0.04;
            if (entity instanceof EntityThrowable) {
                gravity = 0.03;
            } else if (entity instanceof EntityArrow) {
                gravity = 0.05;
            } else if (entity instanceof EntityLivingBase) {
                gravity = 0.08;
            }
            entity.field_70181_x += gravity;
        }
    }

    public static List<ItemStack> getHotbar(EntityPlayer player) {
        NonNullList hotbar = NonNullList.func_191196_a();
        hotbar.addAll((Collection)player.field_71071_by.field_70462_a.subList(0, 9));
        return hotbar;
    }

    public static List<ItemStack> getPrioritisedHotbarAndOffhand(EntityPlayer player) {
        List<ItemStack> hotbar = WizardryUtilities.getHotbar(player);
        hotbar.add(0, player.func_184592_cb());
        hotbar.remove(player.func_184614_ca());
        hotbar.add(0, player.func_184614_ca());
        return hotbar;
    }

    public static boolean doesPlayerHaveItem(EntityPlayer player, Item item) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerOp(EntityPlayer player, MinecraftServer server) {
        return server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }

    public static boolean canDamageBlocks(EntityLivingBase entity, World world) {
        if (entity instanceof EntityPlayer) {
            return Wizardry.settings.playerBlockDamage;
        }
        return ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entity);
    }

    public static int getDefaultAimingError(EnumDifficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return 10;
            }
            case NORMAL: {
                return 6;
            }
            case HARD: {
                return 2;
            }
        }
        return 10;
    }

    public static boolean isLiving(Entity entity) {
        return entity instanceof EntityLivingBase && !(entity instanceof EntityArmorStand);
    }

    public static void chargeCreeper(EntityCreeper creeper) {
        creeper.func_184212_Q().func_187227_b(POWERED, (Object)true);
    }

    public static boolean isCasting(EntityLivingBase caster, Spell spell) {
        if (!spell.isContinuous) {
            return false;
        }
        if (caster instanceof EntityPlayer) {
            ItemStack stack;
            WizardData data = WizardData.get((EntityPlayer)caster);
            if (data != null && data.currentlyCasting() == spell) {
                return true;
            }
            if (caster.func_184587_cr() && (stack = caster.func_184586_b(caster.func_184600_cs())).func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)stack.func_77973_b()).getCurrentSpell(stack) == spell) {
                return true;
            }
        } else if (caster instanceof ISpellCaster && ((ISpellCaster)caster).getContinuousSpell() == spell) {
            return true;
        }
        return false;
    }

    public static boolean isMeleeDamage(DamageSource source) {
        if (!(source instanceof MinionDamage) && source.func_76364_f() != source.func_76346_g()) {
            return false;
        }
        if (source.func_76352_a()) {
            return false;
        }
        if (source.func_76363_c()) {
            return false;
        }
        if (!(source instanceof MinionDamage) && source instanceof IElementalDamage) {
            return false;
        }
        if (!(source.func_76346_g() instanceof EntityLivingBase)) {
            return false;
        }
        return !(source.func_76346_g() instanceof EntityPlayer) || source.func_188404_v() == null || !(source.func_188404_v().func_72438_d(source.func_76346_g().func_174791_d()) > ((EntityLivingBase)source.func_76346_g()).func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
    }

    @Deprecated
    public static boolean verifyUUIDString(String string) {
        return string != null && string.matches("/^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/");
    }

    public static <E> Collection<E> flatten(Collection<? extends Collection<E>> collection) {
        ArrayList result = new ArrayList();
        collection.forEach(result::addAll);
        return Collections.unmodifiableCollection(result);
    }

    static {
        ArrayList<EntityEquipmentSlot> slots = new ArrayList<EntityEquipmentSlot>(Arrays.asList(EntityEquipmentSlot.values()));
        slots.removeIf(slot -> slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR);
        ARMOUR_SLOTS = slots.toArray(new EntityEquipmentSlot[0]);
        POWERED = (DataParameter)ObfuscationReflectionHelper.getPrivateValue(EntityCreeper.class, null, (String)"field_184714_b");
    }

    @FunctionalInterface
    public static interface SurfaceCriteria {
        public static final SurfaceCriteria COLLIDABLE = SurfaceCriteria.basedOn((IBlockState b) -> b.func_185904_a().func_76230_c());
        public static final SurfaceCriteria BUILDABLE = (world, pos, side) -> world.isSideSolid(pos, side) && world.func_180495_p(pos.func_177972_a(side)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177972_a(side));
        public static final SurfaceCriteria SOLID_LIQUID_TO_AIR = (world, pos, side) -> world.func_180495_p(pos).func_185904_a().func_76224_d() || world.isSideSolid(pos, side) && world.func_175623_d(pos.func_177972_a(side));
        public static final SurfaceCriteria NOT_AIR_TO_AIR = SurfaceCriteria.basedOn(World::func_175623_d).flip();
        public static final SurfaceCriteria COLLIDABLE_IGNORING_TREES = SurfaceCriteria.basedOn((World world, BlockPos pos) -> world.func_180495_p(pos).func_185904_a().func_76230_c() && !WizardryUtilities.isTreeBlock(world, pos));

        public boolean test(World var1, BlockPos var2, EnumFacing var3);

        default public SurfaceCriteria flip() {
            return (world, pos, side) -> this.test(world, pos.func_177972_a(side), side.func_176734_d());
        }

        public static SurfaceCriteria basedOn(BiPredicate<World, BlockPos> condition) {
            return (world, pos, side) -> condition.test(world, pos) && !condition.test(world, pos.func_177972_a(side));
        }

        public static SurfaceCriteria basedOn(Predicate<IBlockState> condition) {
            return (world, pos, side) -> condition.test(world.func_180495_p(pos)) && !condition.test(world.func_180495_p(pos.func_177972_a(side)));
        }
    }

    public static final class Operations {
        public static final int ADD = 0;
        public static final int MULTIPLY_FLAT = 1;
        public static final int MULTIPLY_CUMULATIVE = 2;
    }
}

