/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public final class AllyDesignationSystem {
    private AllyDesignationSystem() {
    }

    public static boolean isValidTarget(Entity attacker, Entity target) {
        NBTTagCompound entityNBT;
        if (target == null) {
            return false;
        }
        if (attacker == null) {
            return true;
        }
        if (target == attacker) {
            return false;
        }
        if (target instanceof FakePlayer) {
            return false;
        }
        if (target instanceof IEntityOwnable && ((IEntityOwnable)target).func_70902_q() == attacker) {
            return false;
        }
        if (target instanceof EntityLiving && ((EntityLivingBase)target).func_70644_a(WizardryPotions.mind_control) && (entityNBT = target.getEntityData()) != null && entityNBT.func_186855_b("controllingEntity") && attacker == WizardryUtilities.getEntityByUUID(target.field_70170_p, entityNBT.func_186857_a("controllingEntity"))) {
            return false;
        }
        if (attacker instanceof EntityPlayer && WizardData.get((EntityPlayer)attacker) != null) {
            Entity controller;
            if (target instanceof EntityPlayer) {
                if (WizardData.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)target)) {
                    return false;
                }
            } else if (target instanceof IEntityOwnable) {
                if (AllyDesignationSystem.isOwnerAlly((EntityPlayer)attacker, (IEntityOwnable)target)) {
                    // empty if block
                }
            } else if (target instanceof EntityLiving && ((EntityLivingBase)target).func_70644_a(WizardryPotions.mind_control) && (entityNBT = target.getEntityData()) != null && entityNBT.func_74764_b("controllingEntity") && (controller = WizardryUtilities.getEntityByUUID(target.field_70170_p, entityNBT.func_186857_a("controllingEntity"))) instanceof EntityPlayer && WizardData.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)controller)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAllied(EntityPlayer allyOf, EntityLivingBase possibleAlly) {
        return possibleAlly instanceof EntityPlayer && AllyDesignationSystem.isPlayerAlly(allyOf, (EntityPlayer)possibleAlly) || possibleAlly instanceof IEntityOwnable && (((IEntityOwnable)possibleAlly).func_70902_q() == allyOf || AllyDesignationSystem.isOwnerAlly(allyOf, (IEntityOwnable)possibleAlly));
    }

    public static boolean isPlayerAlly(EntityPlayer allyOf, EntityPlayer possibleAlly) {
        WizardData data = WizardData.get(allyOf);
        return data != null && data.isPlayerAlly(possibleAlly);
    }

    public static boolean isOwnerAlly(EntityPlayer allyOf, IEntityOwnable ownable) {
        WizardData data = WizardData.get(allyOf);
        if (data == null) {
            return false;
        }
        Entity owner = ownable.func_70902_q();
        return owner instanceof EntityPlayer ? data.isPlayerAlly((EntityPlayer)owner) : data.isPlayerAlly(ownable.func_184753_b());
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer && event.getSource() instanceof IElementalDamage) {
            if (event.getEntity() instanceof EntityPlayer) {
                if (Wizardry.settings.friendlyFire.blockPlayers && AllyDesignationSystem.isPlayerAlly((EntityPlayer)event.getSource().func_76346_g(), (EntityPlayer)event.getEntity())) {
                    event.setCanceled(true);
                }
            } else if (Wizardry.settings.friendlyFire.blockOwned && AllyDesignationSystem.isAllied((EntityPlayer)event.getSource().func_76346_g(), event.getEntityLiving())) {
                event.setCanceled(true);
            }
        }
    }

    public static enum FriendlyFire {
        ALL("All", false, false),
        ONLY_PLAYERS("Only players", false, true),
        ONLY_OWNED("Only summoned/tamed creatures", true, false),
        NONE("None", true, true);

        public static final String[] names;
        public final String name;
        public final boolean blockPlayers;
        public final boolean blockOwned;

        private FriendlyFire(String name, boolean blockPlayers, boolean blockOwned) {
            this.name = name;
            this.blockPlayers = blockPlayers;
            this.blockOwned = blockOwned;
        }

        public static FriendlyFire fromName(String name) {
            for (FriendlyFire setting : FriendlyFire.values()) {
                if (!setting.name.equalsIgnoreCase(name)) continue;
                return setting;
            }
            Wizardry.logger.info("Invalid string for the friendly fire setting. Using default (all) instead.");
            return ALL;
        }

        static {
            names = new String[FriendlyFire.values().length];
            for (FriendlyFire setting : FriendlyFire.values()) {
                FriendlyFire.names[setting.ordinal()] = setting.name;
            }
        }
    }
}

