/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SummonSnowGolem
extends Spell {
    public SummonSnowGolem() {
        super("summon_snow_golem", EnumAction.BOW, false);
        this.soundValues(1.0f, 1.0f, 0.4f);
        this.addProperties("summon_radius");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        BlockPos pos = WizardryUtilities.findNearbyFloorSpace((Entity)caster, 2, 4);
        if (pos == null) {
            return false;
        }
        if (!world.field_72995_K) {
            EntitySnowman snowman = new EntitySnowman(world);
            snowman.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)snowman);
        } else {
            for (int i = 0; i < 10; ++i) {
                double x = (double)pos.func_177958_n() + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                double y = (double)pos.func_177956_o() + 0.5 + world.field_73012_v.nextDouble();
                double z = (double)pos.func_177952_p() + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(0.6f, 0.6f, 1.0f).spawn(world);
            }
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    protected String getTranslationKey() {
        return Wizardry.tisTheSeason ? super.getTranslationKey() + "_festive" : super.getTranslationKey();
    }
}

