/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpellMinion<T extends EntityLiving>
extends Spell {
    public static final String MINION_LIFETIME = "minion_lifetime";
    public static final String MINION_COUNT = "minion_count";
    public static final String SUMMON_RADIUS = "summon_radius";
    public static final String HEALTH_MODIFIER = "minion_health";
    private static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";
    protected final Function<World, T> minionFactory;
    protected boolean flying = false;

    public SpellMinion(String name, Function<World, T> minionFactory) {
        this("ebwizardry", name, minionFactory);
    }

    public SpellMinion(String modID, String name, Function<World, T> minionFactory) {
        super(modID, name, EnumAction.BOW, false);
        this.minionFactory = minionFactory;
        this.addProperties(MINION_LIFETIME, MINION_COUNT, SUMMON_RADIUS);
        this.npcSelector((e, o) -> true);
    }

    public SpellMinion<T> flying(boolean flying) {
        this.flying = flying;
        return this;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!this.spawnMinions(world, (EntityLivingBase)caster, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!this.spawnMinions(world, (EntityLivingBase)caster, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.field_72995_K) {
            for (int i = 0; i < this.getProperty(MINION_COUNT).intValue(); ++i) {
                EntityLiving minion = (EntityLiving)this.minionFactory.apply(world);
                minion.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                ((ISummonedCreature)minion).setLifetime((int)(this.getProperty(MINION_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                this.addMinionExtras(minion, pos, null, modifiers, i);
                world.func_72838_d((Entity)minion);
            }
        }
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    protected boolean spawnMinions(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            for (int i = 0; i < this.getProperty(MINION_COUNT).intValue(); ++i) {
                int range = this.getProperty(SUMMON_RADIUS).intValue();
                BlockPos pos = WizardryUtilities.findNearbyFloorSpace((Entity)caster, range, range * 2);
                if (this.flying) {
                    pos = pos != null ? pos.func_177981_b(2) : caster.func_180425_c().func_177964_d(world.field_73012_v.nextInt(range * 2) - range).func_177965_g(world.field_73012_v.nextInt(range * 2) - range);
                } else if (pos == null) {
                    return false;
                }
                T minion = this.createMinion(world, caster, modifiers);
                minion.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                ((ISummonedCreature)minion).setCaster(caster);
                ((ISummonedCreature)minion).setLifetime((int)(this.getProperty(MINION_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                IAttributeInstance attribute = minion.func_110148_a(SharedMonsterAttributes.field_111264_e);
                if (attribute != null) {
                    attribute.func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), 2));
                }
                minion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(HEALTH_MODIFIER, (double)(modifiers.get(HEALTH_MODIFIER) - 1.0f), 2));
                minion.func_70606_j(minion.func_110138_aP());
                this.addMinionExtras(minion, pos, caster, modifiers, i);
                world.func_72838_d(minion);
            }
        }
        return true;
    }

    protected T createMinion(World world, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        return (T)((EntityLiving)this.minionFactory.apply(world));
    }

    protected void addMinionExtras(T minion, BlockPos pos, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int alreadySpawned) {
        minion.func_180482_a(((EntityLiving)minion).field_70170_p.func_175649_E(pos), null);
    }
}

