/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.item.EnumAction;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ShulkerBullet
extends Spell {
    public ShulkerBullet() {
        super("shulker_bullet", EnumAction.NONE, false);
        this.soundValues(2.0f, 1.0f, 0.3f);
        this.addProperties("range");
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!this.shoot(world, (EntityLivingBase)caster, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, EnumFacing.UP, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!this.shoot(world, (EntityLivingBase)caster, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, EnumFacing.UP, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int duration, int ticksInUse, SpellModifiers modifiers) {
        if (!this.shoot(world, null, x, y, z, direction, modifiers)) {
            return false;
        }
        this.playSound(world, x, y, z, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    private boolean shoot(World world, @Nullable EntityLivingBase caster, double x, double y, double z, EnumFacing direction, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            double range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
            List<EntityLivingBase> possibleTargets = WizardryUtilities.getEntitiesWithinRadius(range, x, y, z, world);
            possibleTargets.remove(caster);
            possibleTargets.removeIf(t -> t instanceof EntityArmorStand);
            if (possibleTargets.isEmpty()) {
                return false;
            }
            possibleTargets.sort(Comparator.comparingDouble(t -> t.func_70092_e(x, y, z)));
            Entity target = (Entity)possibleTargets.get(0);
            if (caster != null) {
                world.func_72838_d((Entity)new EntityShulkerBullet(world, caster, target, direction.func_176740_k()));
            } else {
                EntityShulkerBullet bullet = new EntityShulkerBullet(world);
                bullet.func_70012_b(x, y, z, bullet.field_70177_z, bullet.field_70125_A);
                NBTTagCompound nbt = new NBTTagCompound();
                bullet.func_189511_e(nbt);
                nbt.func_74768_a("Dir", direction.func_176745_a());
                BlockPos pos = new BlockPos(target);
                NBTTagCompound targetTag = NBTUtil.func_186862_a((UUID)target.func_110124_au());
                targetTag.func_74768_a("X", pos.func_177958_n());
                targetTag.func_74768_a("Y", pos.func_177956_o());
                targetTag.func_74768_a("Z", pos.func_177952_p());
                NBTExtras.storeTagSafely(nbt, "Target", (NBTBase)targetTag);
                bullet.func_70020_e(nbt);
                world.func_72838_d((Entity)bullet);
            }
        }
        return true;
    }
}

