/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Shockwave
extends Spell {
    public static final String MAX_REPULSION_VELOCITY = "max_repulsion_velocity";
    private static final double EPICENTRE_RADIUS = 1.0;

    public Shockwave() {
        super("shockwave", EnumAction.BOW, false);
        this.soundValues(2.0f, 0.5f, 0.0f);
        this.addProperties("blast_radius", "damage", MAX_REPULSION_VELOCITY);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double radius = this.getProperty("blast_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(radius, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (target instanceof EntityPlayer && (!Wizardry.settings.playersMoveEachOther || ItemArtefact.isArtefactActive((EntityPlayer)target, WizardryItems.amulet_anchoring))) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
                return false;
            }
            if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target)) continue;
            float proximity = (float)(1.0 - Math.max((double)target.func_70032_d((Entity)caster) - 1.0, 0.0) / (radius - 1.0));
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.BLAST), this.getProperty("damage").floatValue() * proximity * modifiers.get("potency"));
            if (world.field_72995_K) continue;
            double velocityFactor = proximity * this.getProperty(MAX_REPULSION_VELOCITY).floatValue();
            double dx = target.field_70165_t - caster.field_70165_t;
            double dy = target.func_174813_aQ().field_72338_b + 1.0 - caster.field_70163_u;
            double dz = target.field_70161_v - caster.field_70161_v;
            target.field_70159_w = velocityFactor * dx;
            target.field_70181_x = velocityFactor * dy;
            target.field_70179_y = velocityFactor * dz;
            if (!(target instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                double particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                double particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                IBlockState block = WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster);
                if (block == null) continue;
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, caster.func_174813_aQ().field_72338_b, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
            }
            ParticleBuilder.create(ParticleBuilder.Type.SPHERE).pos(caster.field_70165_t, caster.func_174813_aQ().field_72338_b + 0.1, caster.field_70161_v).scale((float)radius * 0.8f).clr(0.8f, 0.9f, 1.0f).spawn(world);
            world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, caster.field_70165_t, caster.func_174813_aQ().field_72338_b + 0.1, caster.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        caster.func_184609_a(hand);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }
}

