/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Paralysis
extends SpellRay {
    private static final String CRITICAL_HEALTH = "critical_health";

    public Paralysis() {
        super("paralysis", false, EnumAction.NONE);
        this.addProperties("damage", "effect_duration", CRITICAL_HEALTH);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving(target)) {
            if (world.field_72995_K) {
                ParticleBuilder.create(ParticleBuilder.Type.BEAM).entity((Entity)caster).clr(0.2f, 0.6f, 1.0f).pos(caster != null ? origin.func_178788_d(caster.func_174791_d()) : origin).target(target).spawn(world);
                ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity((Entity)caster).pos(caster != null ? origin.func_178788_d(caster.func_174791_d()) : origin).target(target).spawn(world);
            }
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
                if (!world.field_72995_K && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), this.getProperty("damage").floatValue() * modifiers.get("potency"));
            }
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.paralysis, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), 0));
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K && world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            Vec3d vec = hit.func_178787_e(new Vec3d(side.func_176730_m()).func_186678_a(0.005));
            ParticleBuilder.create(ParticleBuilder.Type.SCORCH).pos(vec).face(side).clr(0.4f, 0.8f, 1.0f).spawn(world);
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a((double)(this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade))));
        if (world.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).time(4).pos(origin).target(endpoint).scale(0.5f).spawn(world);
            ParticleBuilder.create(ParticleBuilder.Type.BEAM).clr(0.2f, 0.6f, 1.0f).time(4).pos(origin).target(endpoint).spawn(world);
        }
        return true;
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityLiving && event.getEntityLiving().func_70644_a(WizardryPotions.paralysis)) {
            int timeLeft = event.getEntityLiving().func_70660_b(WizardryPotions.paralysis).func_76459_b();
            ((EntityLiving)event.getEntity()).func_94061_f(timeLeft > 1);
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.getEntityLiving().func_70644_a(WizardryPotions.paralysis) && event.getEntityLiving().func_110143_aJ() - event.getAmount() <= Spells.paralysis.getProperty(CRITICAL_HEALTH).floatValue()) {
            event.getEntityLiving().func_184589_d(WizardryPotions.paralysis);
        }
    }
}

