/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class Glide
extends Spell {
    public static final String SPEED = "speed";
    public static final String FALL_SPEED = "fall_speed";
    public static final String ACCELERATION = "acceleration";

    public Glide() {
        super("glide", EnumAction.NONE, true);
        this.addProperties(SPEED, FALL_SPEED, ACCELERATION);
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        if (ticksInUse == 0 && world.field_72995_K) {
            Wizardry.proxy.playSpellSoundLoop(entity, this, this.sounds[0], this.sounds[0], this.sounds[0], WizardrySounds.SPELLS, this.volume, this.pitch + this.pitchVariation * (world.field_73012_v.nextFloat() - 0.5f));
        }
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        if (ticksInUse == 0 && world.field_72995_K) {
            Wizardry.proxy.playSpellSoundLoop(world, x, y, z, this, this.sounds[0], this.sounds[0], this.sounds[0], WizardrySounds.SPELLS, this.volume, this.pitch + this.pitchVariation * (world.field_73012_v.nextFloat() - 0.5f), duration);
        }
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.field_70181_x < -0.1 && !caster.func_70090_H()) {
            float speed = this.getProperty(SPEED).floatValue() * modifiers.get("potency");
            float acceleration = this.getProperty(ACCELERATION).floatValue() * modifiers.get("potency");
            caster.field_70181_x = -this.getProperty(FALL_SPEED).floatValue();
            if (Math.abs(caster.field_70159_w) < (double)speed && Math.abs(caster.field_70179_y) < (double)speed) {
                caster.func_70024_g(caster.func_70040_Z().field_72450_a * (double)acceleration, 0.0, caster.func_70040_Z().field_72449_c * (double)acceleration);
            }
            if (!Wizardry.settings.replaceVanillaFallDamage) {
                caster.field_70143_R = 0.0f;
            }
        }
        if (world.field_72995_K) {
            double x = caster.field_70165_t - 0.25 + world.field_73012_v.nextDouble() / 2.0;
            double y = caster.func_174813_aQ().field_72338_b + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v - 0.25 + world.field_73012_v.nextDouble() / 2.0;
            ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).clr(1.0f, 1.0f, 1.0f).spawn(world);
            x = caster.field_70165_t - 0.25 + world.field_73012_v.nextDouble() / 2.0;
            y = caster.func_174813_aQ().field_72338_b + world.field_73012_v.nextDouble();
            z = caster.field_70161_v - 0.25 + world.field_73012_v.nextDouble() / 2.0;
            ParticleBuilder.create(ParticleBuilder.Type.LEAF).pos(x, y, z).time(20).spawn(world);
        }
        if (ticksInUse % 24 == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return true;
    }
}

