/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.registry.WizardryEnchantments;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.ImbueWeapon;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class FreezingWeapon
extends Spell {
    public static final String FREEZING_ARROW_NBT_KEY = "frostLevel";

    public FreezingWeapon() {
        super("freezing_weapon", EnumAction.BOW, false);
        this.addProperties("effect_duration");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (WizardData.get(caster) != null && WizardData.get(caster).getImbuementDuration(WizardryEnchantments.freezing_weapon) <= 0) {
            for (ItemStack stack : WizardryUtilities.getPrioritisedHotbarAndOffhand(caster)) {
                if (!ImbueWeapon.isSword(stack.func_77973_b()) && !ImbueWeapon.isBow(stack.func_77973_b()) || EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(WizardryEnchantments.freezing_weapon)) continue;
                stack.func_77966_a(WizardryEnchantments.freezing_weapon, modifiers.get("potency") == 1.0f ? 1 : (int)((modifiers.get("potency") - 1.0f) / 0.15f + 0.5f));
                WizardData.get(caster).setImbuementDuration(WizardryEnchantments.freezing_weapon, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                if (world.field_72995_K) {
                    for (int i = 0; i < 10; ++i) {
                        double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                        double y = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
                        double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(0.9f, 0.7f, 1.0f).spawn(world);
                    }
                }
                this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                return true;
            }
        }
        return false;
    }
}

