/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Freeze
extends SpellRay {
    public Freeze() {
        super("freeze", false, EnumAction.NONE);
        this.soundValues(1.0f, 1.4f, 0.4f);
        this.addProperties("damage", "effect_duration", "effect_strength");
        this.hitLiquids(true);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving(target)) {
            if (target instanceof EntityBlaze || target instanceof EntityMagmaCube) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.FROST), this.getProperty("damage").floatValue() * modifiers.get("potency"));
            }
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, target)) {
                if (!world.field_72995_K && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.frost, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue()));
            }
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.canDamageBlocks(caster, world)) {
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && !world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
            } else if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l && !world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
            } else if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150356_k && !world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
            } else if (side == EnumFacing.UP && !world.field_72995_K && world.isSideSolid(pos, EnumFacing.UP) && WizardryUtilities.canBlockBeReplaced(world, pos.func_177984_a())) {
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
            }
        }
        return true;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = 0.5f + world.field_73012_v.nextFloat() / 2.0f;
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(brightness, brightness + 0.1f, 1.0f).spawn(world);
        ParticleBuilder.create(ParticleBuilder.Type.SNOW).pos(x, y, z).spawn(world);
    }
}

