/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.block.BlockThorns;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityPlayerSaveTimed;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ForestOfThorns
extends Spell {
    public ForestOfThorns() {
        super("forest_of_thorns", EnumAction.BOW, false);
        this.addProperties("effect_radius", "duration", "damage");
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!this.summonThorns(world, (EntityLivingBase)caster, caster.func_180425_c(), modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!this.summonThorns(world, (EntityLivingBase)caster, caster.func_180425_c(), modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        if (!this.summonThorns(world, null, new BlockPos(x, y, z).func_177972_a(direction), modifiers)) {
            return false;
        }
        this.playSound(world, x, y, z, ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    private boolean summonThorns(World world, @Nullable EntityLivingBase caster, BlockPos origin, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            double radius = this.getProperty("effect_radius").doubleValue() * (double)modifiers.get(WizardryItems.blast_upgrade);
            ArrayList<BlockPos> ring = new ArrayList<BlockPos>((int)(7.0 * radius));
            int x = -((int)radius);
            while ((double)x <= radius) {
                int z = -((int)radius);
                while ((double)z <= radius) {
                    Integer y;
                    double distance = MathHelper.func_76129_c((float)(x * x + z * z));
                    if (!(distance > radius) && !(distance < radius - 1.5) && (y = WizardryUtilities.getNearestSurface(world, origin.func_177982_a(x, 0, z), EnumFacing.UP, (int)radius, true, WizardryUtilities.SurfaceCriteria.BUILDABLE)) != null) {
                        ring.add(new BlockPos(origin.func_177958_n() + x, y.intValue(), origin.func_177952_p() + z));
                    }
                    ++z;
                }
                ++x;
            }
            if (ring.isEmpty()) {
                return false;
            }
            for (BlockPos pos : ring) {
                ((BlockThorns)WizardryBlocks.thorns).placeAt(world, pos, 3);
                for (int i = 0; i < 2; ++i) {
                    TileEntity tileentity = world.func_175625_s(pos.func_177981_b(i));
                    if (!(tileentity instanceof TileEntityPlayerSaveTimed)) continue;
                    ((TileEntityPlayerSaveTimed)tileentity).setLifetime((int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                    if (caster == null) continue;
                    ((TileEntityPlayerSaveTimed)tileentity).setCaster(caster);
                }
            }
        }
        return true;
    }
}

