/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ConjureBlock
extends SpellRay {
    private static final String BLOCK_LIFETIME = "block_lifetime";

    public ConjureBlock() {
        super("conjure_block", false, EnumAction.NONE);
        this.ignoreLivingEntities(true);
        this.addProperties(BLOCK_LIFETIME);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster.func_70093_af() && world.func_180495_p(pos).func_177230_c() == WizardryBlocks.spectral_block) {
            if (!world.field_72995_K) {
                world.func_175698_g(pos);
            } else {
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).scale(3.0f).clr(0.75f, 1.0f, 0.85f).spawn(world);
            }
            return true;
        }
        pos = pos.func_177972_a(side);
        if (world.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).scale(3.0f).clr(0.75f, 1.0f, 0.85f).spawn(world);
        }
        if (WizardryUtilities.canBlockBeReplaced(world, pos)) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, WizardryBlocks.spectral_block.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                    ((TileEntityTimer)world.func_175625_s(pos)).setLifetime((int)(this.getProperty(BLOCK_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

