/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Cobwebs
extends SpellRay {
    public Cobwebs() {
        super("cobwebs", false, EnumAction.NONE);
        this.ignoreLivingEntities(true);
        this.addProperties("effect_radius", "duration");
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        boolean flag = false;
        pos = pos.func_177972_a(side);
        int blastUpgradeCount = (int)((modifiers.get(WizardryItems.blast_upgrade) - 1.0f) / 0.25f + 0.5f);
        float radius = this.getProperty("effect_radius").floatValue() + 0.73f * (float)blastUpgradeCount;
        List<BlockPos> sphere = WizardryUtilities.getBlockSphere(pos, radius * modifiers.get(WizardryItems.blast_upgrade));
        for (BlockPos pos1 : sphere) {
            if (!world.func_175623_d(pos1)) continue;
            if (!world.field_72995_K) {
                world.func_175656_a(pos1, WizardryBlocks.vanishing_cobweb.func_176223_P());
                if (world.func_175625_s(pos1) instanceof TileEntityTimer) {
                    ((TileEntityTimer)world.func_175625_s(pos1)).setLifetime((int)(this.getProperty("duration").doubleValue() * (double)modifiers.get(WizardryItems.duration_upgrade)));
                }
            }
            flag = true;
        }
        return flag;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

