/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.registry;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.loot.RandomSpell;
import electroblob.wizardry.loot.WizardSpell;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber
public final class WizardryLoot {
    private WizardryLoot() {
    }

    public static void register() {
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new RandomSpell.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new WizardSpell.Serializer());
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "chests/wizard_tower"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "chests/obelisk"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "chests/shrine"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "chests/dungeon_additions"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "chests/jungle_dispenser_additions"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "subsets/elemental_crystals"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "subsets/wizard_armour"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "subsets/arcane_tomes"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "subsets/wand_upgrades"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "entities/evil_wizard"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("ebwizardry", "entities/mob_additions"));
    }

    @Deprecated
    public static int getStandardWeightedRandomSpellId(Random random, Predicate<Spell> filter) {
        Tier tier = Tier.getWeightedRandomTier(random, new Tier[0]);
        List<Spell> spells = Spell.getSpells(new Spell.TierElementFilter(tier, null, new SpellProperties.Context[0]));
        spells.removeIf(filter.negate());
        if (spells.isEmpty()) {
            spells = Spell.getSpells(new Spell.TierElementFilter(Tier.NOVICE, null, new SpellProperties.Context[0]));
            spells.removeIf(filter.negate());
        }
        if (spells.isEmpty()) {
            return -1;
        }
        return spells.get(random.nextInt(spells.size())).metadata();
    }

    @SubscribeEvent
    public static void onLootTableLoadEvent(LootTableLoadEvent event) {
        if (Arrays.asList(Wizardry.settings.lootInjectionLocations).contains(event.getName())) {
            event.getTable().addPool(WizardryLoot.getAdditive("ebwizardry:chests/dungeon_additions", "ebwizardry_additional_dungeon_loot"));
        }
        if (event.getName().toString().matches("minecraft:chests/jungle_temple_dispenser")) {
            event.getTable().addPool(WizardryLoot.getAdditive("ebwizardry:chests/jungle_dispenser_additions", "ebwizardry_additional_dispenser_loot"));
        }
        if (Arrays.asList(Wizardry.settings.mobLootTableWhitelist).contains(event.getName())) {
            event.getTable().addPool(WizardryLoot.getAdditive("ebwizardry:entities/mob_additions", "ebwizardry_additional_mob_drops"));
        } else if (!Arrays.asList(Wizardry.settings.mobLootTableBlacklist).contains(event.getName()) && event.getName().func_110623_a().contains("entities") || event.getName().func_110623_a().contains("entity")) {
            String[] split = event.getName().func_110623_a().split("/");
            String entityName = split[split.length - 1];
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityName));
            if (entry == null) {
                return;
            }
            Class entityClass = entry.getEntityClass();
            if (EnumCreatureType.MONSTER.func_75598_a().isAssignableFrom(entityClass)) {
                event.getTable().addPool(WizardryLoot.getAdditive("ebwizardry:entities/mob_additions", "ebwizardry_additional_mob_drops"));
            }
        }
    }

    private static LootPool getAdditive(String entryName, String poolName) {
        return new LootPool(new LootEntry[]{WizardryLoot.getAdditiveEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "ebwizardry_" + poolName);
    }

    private static LootEntryTable getAdditiveEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation(name), weight, 0, new LootCondition[0], "ebwizardry_additive_entry");
    }
}

