/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.commons.lang3.ArrayUtils;

public class RandomSpell
extends LootFunction {
    private final List<Spell> spells;
    private final boolean ignoreWeighting;
    private final float undiscoveredBias;
    private final List<Tier> tiers;
    private final List<Element> elements;

    protected RandomSpell(LootCondition[] conditions, List<Spell> spells, boolean ignoreWeighting, float undiscoveredBias, List<Tier> tiers, List<Element> elements) {
        super(conditions);
        this.spells = spells;
        this.ignoreWeighting = ignoreWeighting;
        this.undiscoveredBias = undiscoveredBias;
        this.tiers = tiers;
        this.elements = elements;
    }

    public ItemStack func_186553_a(ItemStack stack, Random random, LootContext context) {
        Element element;
        if (!(stack.func_77973_b() instanceof ItemSpellBook) && !(stack.func_77973_b() instanceof ItemScroll)) {
            Wizardry.logger.warn("Applying the random_spell loot function to an item that isn't a spell book or scroll.");
        }
        Tier tier = this.ignoreWeighting ? (this.tiers == null || this.tiers.isEmpty() ? Tier.values()[random.nextInt(Tier.values().length)] : this.tiers.get(random.nextInt(this.tiers.size()))) : (this.tiers == null || this.tiers.isEmpty() ? Tier.getWeightedRandomTier(random, new Tier[0]) : Tier.getWeightedRandomTier(random, this.tiers.toArray(new Tier[0])));
        if (this.elements == null || this.elements.isEmpty()) {
            if (tier == Tier.NOVICE) {
                element = Element.values()[random.nextInt(Element.values().length)];
            } else {
                Element[] elements = (Element[])ArrayUtils.removeElement((Object[])Element.values(), (Object)((Object)Element.MAGIC));
                element = elements[random.nextInt(elements.length)];
            }
        } else {
            element = this.elements.get(random.nextInt(this.elements.size()));
        }
        SpellProperties.Context spellContext = context.func_186493_a() == null ? SpellProperties.Context.TREASURE : SpellProperties.Context.LOOTING;
        List<Spell> spellsList = Spell.getSpells(new Spell.TierElementFilter(tier, element, spellContext));
        spellsList.removeIf(s -> !s.applicableForItem(stack.func_77973_b()));
        if (stack.func_77973_b() instanceof ItemScroll) {
            spellsList.removeIf(s -> !s.isEnabled(SpellProperties.Context.SCROLL));
        }
        if (stack.func_77973_b() instanceof ItemSpellBook) {
            spellsList.removeIf(s -> !s.isEnabled(SpellProperties.Context.BOOK));
        }
        if (this.spells != null && !this.spells.isEmpty()) {
            spellsList.retainAll(this.spells);
        }
        EntityPlayer player = (EntityPlayer)context.func_186495_b();
        if (this.undiscoveredBias > 0.0f && player != null) {
            WizardData data = WizardData.get(player);
            int discoveredCount = (int)spellsList.stream().filter(data::hasSpellBeenDiscovered).count();
            if (discoveredCount > 0 && discoveredCount < spellsList.size()) {
                boolean keepDiscovered = random.nextFloat() < 0.5f + 0.5f * this.undiscoveredBias;
                spellsList.removeIf(s -> keepDiscovered != data.hasSpellBeenDiscovered((Spell)s));
            }
        }
        if (spellsList.isEmpty()) {
            Wizardry.logger.warn("Tried to apply the random_spell loot function to an item, but no enabled spellsmatched the criteria specified. Substituting placeholder (metadata 0) item.");
            stack.func_77964_b(0);
        } else {
            stack.func_77964_b(spellsList.get(random.nextInt(spellsList.size())).metadata());
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomSpell> {
        public Serializer() {
            super(new ResourceLocation("ebwizardry", "random_spell"), RandomSpell.class);
        }

        public void serialize(JsonObject object, RandomSpell function, JsonSerializationContext serializationContext) {
            JsonArray jsonarray;
            if (function.spells != null && !function.spells.isEmpty()) {
                jsonarray = new JsonArray();
                for (Spell spell : function.spells) {
                    jsonarray.add((JsonElement)new JsonPrimitive(spell.getRegistryName().toString()));
                }
                object.add("spells", (JsonElement)jsonarray);
            }
            object.addProperty("ignore_weighting", Boolean.valueOf(function.ignoreWeighting));
            object.addProperty("undiscovered_bias", (Number)Float.valueOf(function.undiscoveredBias));
            if (function.tiers != null && !function.tiers.isEmpty()) {
                jsonarray = new JsonArray();
                for (Tier tier : function.tiers) {
                    jsonarray.add((JsonElement)new JsonPrimitive(tier.getUnlocalisedName()));
                }
                object.add("tiers", (JsonElement)jsonarray);
            }
            if (function.elements != null && !function.elements.isEmpty()) {
                jsonarray = new JsonArray();
                for (Element element : function.elements) {
                    jsonarray.add((JsonElement)new JsonPrimitive(element.func_176610_l()));
                }
                object.add("elements", (JsonElement)jsonarray);
            }
        }

        public RandomSpell deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditions) {
            String string;
            ArrayList<Spell> spells = null;
            ArrayList<Tier> tiers = null;
            ArrayList<Element> elements = null;
            if (object.has("spells")) {
                spells = new ArrayList<Spell>();
                for (JsonElement element : JsonUtils.func_151213_a((JsonObject)object, (String)"spells", (JsonArray)new JsonArray())) {
                    String string2 = JsonUtils.func_151206_a((JsonElement)element, (String)"spell");
                    Spell spell = Spell.get(string2);
                    if (spell == null) {
                        throw new JsonSyntaxException("Unknown spell '" + string2 + "'");
                    }
                    spells.add(spell);
                }
            }
            boolean ignoreWeighting = JsonUtils.func_151209_a((JsonObject)object, (String)"ignore_weighting", (boolean)false);
            float undiscoveredBias = JsonUtils.func_151221_a((JsonObject)object, (String)"undiscovered_bias", (float)0.0f);
            if (object.has("tiers")) {
                tiers = new ArrayList<Tier>();
                for (JsonElement element : JsonUtils.func_151213_a((JsonObject)object, (String)"tiers", (JsonArray)new JsonArray())) {
                    string = JsonUtils.func_151206_a((JsonElement)element, (String)"tier");
                    try {
                        tiers.add(Tier.fromName(string));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonSyntaxException("Unknown tier '" + string + "'");
                    }
                }
            }
            if (object.has("elements")) {
                elements = new ArrayList<Element>();
                for (JsonElement jelement : JsonUtils.func_151213_a((JsonObject)object, (String)"elements", (JsonArray)new JsonArray())) {
                    string = JsonUtils.func_151206_a((JsonElement)jelement, (String)"element");
                    try {
                        elements.add(Element.fromName(string));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonSyntaxException("Unknown element '" + string + "'");
                    }
                }
            }
            return new RandomSpell(conditions, spells, ignoreWeighting, undiscoveredBias, tiers, elements);
        }
    }
}

