/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryRecipes;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemWizardArmour
extends ItemArmor
implements IWorkbenchItem,
IManaStoringItem {
    public static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static int[] reductions = new int[]{2, 4, 5, 2};
    public Element element;

    public ItemWizardArmour(ItemArmor.ArmorMaterial material, int renderIndex, EntityEquipmentSlot armourType, Element element) {
        super(material, renderIndex, armourType);
        this.element = element;
        this.func_77637_a(WizardryTabs.GEAR);
        WizardryRecipes.addToManaFlaskCharging((Item)this);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (stack.func_77952_i() < damage) {
            super.setDamage(stack, Math.min(damage, stack.func_77958_k()));
        }
    }

    @Override
    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    @Override
    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    @Override
    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("legendary")) {
            tooltip.add("\u00a7d" + I18n.func_135052_a((String)"item.ebwizardry:wizard_armour.legendary", (Object[])new Object[0]));
        }
        if (this.element != null) {
            tooltip.add("\u00a78" + I18n.func_135052_a((String)"item.ebwizardry:wizard_armour.buff", (Object[])new Object[]{"15%", this.element.getDisplayName()}));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return (this.element == null ? "" : this.element.getFormattingCode()) + super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armourSlot, ModelBiped _default) {
        if (armourSlot == EntityEquipmentSlot.LEGS && !entityLiving.func_82150_aj()) {
            return null;
        }
        ModelBiped model = Wizardry.proxy.getWizardArmourModel();
        if (model != null) {
            ItemStack itemstackL;
            model.field_78116_c.field_78806_j = armourSlot == EntityEquipmentSlot.HEAD;
            model.field_178720_f.field_78806_j = false;
            model.field_78115_e.field_78806_j = armourSlot == EntityEquipmentSlot.CHEST;
            model.field_178723_h.field_78806_j = armourSlot == EntityEquipmentSlot.CHEST;
            model.field_178724_i.field_78806_j = armourSlot == EntityEquipmentSlot.CHEST;
            model.field_178721_j.field_78806_j = armourSlot == EntityEquipmentSlot.FEET;
            model.field_178722_k.field_78806_j = armourSlot == EntityEquipmentSlot.FEET;
            model.field_78117_n = entityLiving.func_70093_af();
            model.field_78093_q = entityLiving.func_184218_aH();
            model.field_78091_s = entityLiving.func_70631_g_();
            boolean leftHanded = entityLiving.func_184591_cq() == EnumHandSide.LEFT;
            ItemStack itemstackR = leftHanded ? entityLiving.func_184592_cb() : entityLiving.func_184614_ca();
            ItemStack itemStack2 = itemstackL = leftHanded ? entityLiving.func_184614_ca() : entityLiving.func_184592_cb();
            if (!itemstackR.func_190926_b()) {
                model.field_187076_m = ModelBiped.ArmPose.ITEM;
                if (entityLiving.func_184605_cv() > 0) {
                    EnumAction enumaction = itemstackR.func_77975_n();
                    if (enumaction == EnumAction.BLOCK) {
                        model.field_187076_m = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction == EnumAction.BOW) {
                        model.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (!itemstackL.func_190926_b()) {
                model.field_187075_l = ModelBiped.ArmPose.ITEM;
                if (entityLiving.func_184605_cv() > 0) {
                    EnumAction enumaction1 = itemstackL.func_77975_n();
                    if (enumaction1 == EnumAction.BLOCK) {
                        model.field_187075_l = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction1 == EnumAction.BOW) {
                        model.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
        }
        return model;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String s = "wizard_armour";
        if (Wizardry.tisTheSeason) {
            s = s + "_festive";
        } else {
            if (this.element != null) {
                s = s + "_" + this.element.func_176610_l();
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("legendary")) {
                s = "legendary_" + s;
            }
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            s = s + "_legs";
        }
        return "ebwizardry:textures/armour/" + s + ".png";
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        if (!this.isManaEmpty(stack) && this.field_77881_a == slot) {
            int defense = reductions[slot.func_188454_b()];
            float toughness = 0.0f;
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("legendary")) {
                defense = ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(slot);
                toughness = ItemArmor.ArmorMaterial.DIAMOND.func_189416_e();
            }
            map.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor modifier", (double)defense, 0));
            map.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor toughness", (double)toughness, 0));
        }
        return map;
    }

    @Override
    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    @Override
    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    @Override
    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (upgrade.func_75211_c().func_77973_b() == WizardryItems.armour_upgrade) {
            if (!centre.func_75211_c().func_77942_o()) {
                centre.func_75211_c().func_77982_d(new NBTTagCompound());
            }
            if (!centre.func_75211_c().func_77978_p().func_74764_b("legendary")) {
                centre.func_75211_c().func_77978_p().func_74757_a("legendary", true);
                upgrade.func_75209_a(1);
                WizardryAdvancementTriggers.legendary.triggerFor(player);
                changed = true;
            }
        }
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            if (crystals.func_75211_c().func_190916_E() * 100 < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * 100);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / 100.0));
            }
            changed = true;
        }
        return changed;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() == null) {
            return;
        }
        int armourPieces = ItemWizardArmour.getMatchingArmourCount(event.getCaster(), event.getSpell().getElement());
        float multiplier = 1.0f - (float)armourPieces * 0.15f;
        if (armourPieces == WizardryUtilities.ARMOUR_SLOTS.length) {
            multiplier -= 0.2f;
        }
        event.getModifiers().set("cost", event.getModifiers().get("cost") * multiplier, false);
    }

    public static int getMatchingArmourCount(EntityLivingBase entity, Element element) {
        return (int)Arrays.stream(WizardryUtilities.ARMOUR_SLOTS).map(s -> entity.func_184582_a(s).func_77973_b()).filter(i -> i instanceof ItemWizardArmour && ((ItemWizardArmour)i).element == element).count();
    }

    @SubscribeEvent
    public static void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityLiving && event.getEntityLiving().func_82150_aj()) {
            float f;
            double followRange;
            int armourPieces = (int)Streams.stream((Iterable)event.getTarget().func_184193_aE()).filter(s -> !s.func_190926_b() && !(s.func_77973_b() instanceof ItemWizardArmour)).count();
            if (armourPieces == 0) {
                return;
            }
            IAttributeInstance attribute = event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111265_b);
            double d = followRange = attribute == null ? 16.0 : attribute.func_111126_e();
            if (event.getTarget().func_70093_af()) {
                followRange *= 0.8;
            }
            if ((f = (float)armourPieces / (float)((EntityPlayer)event.getTarget()).field_71071_by.field_70460_b.size()) < 0.1f) {
                f = 0.1f;
            }
            followRange *= (double)(0.7f * f);
            if ((double)event.getTarget().func_70032_d(event.getEntity()) > followRange) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }
}

