/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import com.google.common.collect.ImmutableMap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryGuiHandler;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpellBook
extends Item {
    private static final Map<Tier, ResourceLocation> guiTextures = ImmutableMap.of((Object)((Object)Tier.NOVICE), (Object)new ResourceLocation("ebwizardry", "textures/gui/spell_book_novice.png"), (Object)((Object)Tier.APPRENTICE), (Object)new ResourceLocation("ebwizardry", "textures/gui/spell_book_apprentice.png"), (Object)((Object)Tier.ADVANCED), (Object)new ResourceLocation("ebwizardry", "textures/gui/spell_book_advanced.png"), (Object)((Object)Tier.MASTER), (Object)new ResourceLocation("ebwizardry", "textures/gui/spell_book_master.png"));

    public ItemSpellBook() {
        this.func_77627_a(true);
        this.func_77625_d(16);
        this.func_77637_a(WizardryTabs.SPELLS);
        this.func_185043_a(new ResourceLocation("festive"), (s, w, e) -> Wizardry.tisTheSeason ? 1.0f : 0.0f);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == WizardryTabs.SPELLS) {
            List<Spell> spells = Spell.getAllSpells();
            spells.removeIf(s -> !s.applicableForItem(this));
            for (Spell spell : spells) {
                list.add((Object)new ItemStack((Item)this, 1, spell.metadata()));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.openGui((Object)Wizardry.instance, WizardryGuiHandler.SPELL_BOOK, world, 0, 0, 0);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (world != null && itemstack.func_77952_i() != Short.MAX_VALUE) {
            Spell spell = Spell.byMetadata(itemstack.func_77952_i());
            boolean discovered = Wizardry.proxy.shouldDisplayDiscovered(spell, itemstack);
            tooltip.add(discovered ? "\u00a77" + spell.getDisplayNameWithFormatting() : "#\u00a79" + SpellGlyphData.getGlyphName(spell, world));
            tooltip.add(spell.getTier().getDisplayNameWithFormatting());
            if (discovered && advanced.func_194127_a()) {
                tooltip.add(spell.getElement().getDisplayName());
                tooltip.add(spell.getType().getDisplayName());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return Wizardry.proxy.getFontRenderer(stack);
    }

    public ResourceLocation getGuiTexture(Spell spell) {
        return guiTextures.get((Object)spell.getTier());
    }
}

