/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScroll
extends Item
implements ISpellCastingItem {
    public static final int CASTING_TIME = 120;

    public ItemScroll() {
        this.func_77627_a(true);
        this.func_77625_d(16);
        this.func_77637_a(WizardryTabs.SPELLS);
        this.func_185043_a(new ResourceLocation("festive"), (s, w, e) -> Wizardry.tisTheSeason ? 1.0f : 0.0f);
    }

    @Override
    public Spell getCurrentSpell(ItemStack stack) {
        return Spell.byMetadata(stack.func_77952_i());
    }

    @Override
    public boolean showSpellHUD(EntityPlayer player, ItemStack stack) {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == WizardryTabs.SPELLS) {
            List<Spell> spells = Spell.getAllSpells();
            spells.removeIf(s -> !s.applicableForItem(this));
            for (Spell spell : spells) {
                list.add((Object)new ItemStack((Item)this, 1, spell.metadata()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        return Wizardry.proxy.getScrollDisplayName(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> tooltip, ITooltipFlag advanced) {
        Spell spell;
        boolean discovered;
        if (world != null && (discovered = Wizardry.proxy.shouldDisplayDiscovered(spell = Spell.byMetadata(itemstack.func_77952_i()), itemstack)) && advanced.func_194127_a()) {
            tooltip.add(spell.getTier().getDisplayName());
            tooltip.add(spell.getElement().getDisplayName());
            tooltip.add(spell.getType().getDisplayName());
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 120;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        SpellModifiers modifiers;
        Spell spell;
        ItemStack stack = player.func_184586_b(hand);
        if (this.canCast(stack, spell = Spell.byMetadata(stack.func_77952_i()), player, hand, 0, modifiers = new SpellModifiers())) {
            if (spell.isContinuous) {
                if (!player.func_184587_cr()) {
                    player.func_184598_c(hand);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (this.cast(stack, spell, player, hand, 0, modifiers)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            Spell spell = Spell.byMetadata(stack.func_77952_i());
            SpellModifiers modifiers = new SpellModifiers();
            int castingTick = stack.func_77988_m() - count;
            if (spell.isContinuous && this.canCast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers)) {
                this.cast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers);
            } else {
                player.func_184597_cx();
            }
        }
    }

    @Override
    public boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        if (castingTick == 0) {
            return !MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.SCROLL, spell, (EntityLivingBase)caster, modifiers));
        }
        return !MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.SCROLL, spell, (EntityLivingBase)caster, modifiers, castingTick));
    }

    @Override
    public boolean cast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        World world = caster.field_70170_p;
        if (world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
            return false;
        }
        if (spell.cast(world, caster, hand, castingTick, modifiers)) {
            if (castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.SCROLL, spell, (EntityLivingBase)caster, modifiers));
            }
            if (!world.field_72995_K) {
                if (!spell.isContinuous && spell.requiresPacket()) {
                    PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), hand, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
                }
                if (!spell.isContinuous && !caster.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase user, int timeLeft) {
        if (!(!Spell.byMetadata((int)stack.func_77952_i()).isContinuous || user instanceof EntityPlayer && ((EntityPlayer)user).func_184812_l_())) {
            stack.func_190918_g(1);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase user) {
        if (!(!Spell.byMetadata((int)stack.func_77952_i()).isContinuous || user instanceof EntityPlayer && ((EntityPlayer)user).func_184812_l_())) {
            stack.func_190918_g(1);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return Wizardry.proxy.getFontRenderer(stack);
    }
}

