/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.integration.antiqueatlas;

import electroblob.wizardry.Wizardry;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.registry.MarkerType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class WizardryAntiqueAtlasIntegration {
    public static final String ANTIQUE_ATLAS_MOD_ID = "antiqueatlas";
    private static final ResourceLocation TOWER_MARKER = new ResourceLocation("ebwizardry", "wizard_tower");
    private static final ResourceLocation SHRINE_MARKER = new ResourceLocation("ebwizardry", "shrine");
    private static final ResourceLocation OBELISK_MARKER = new ResourceLocation("ebwizardry", "obelisk");
    private static boolean antiqueAtlasLoaded;

    public static void init() {
        antiqueAtlasLoaded = Loader.isModLoaded((String)ANTIQUE_ATLAS_MOD_ID);
        Wizardry.proxy.registerAtlasMarkers();
    }

    public static boolean enabled() {
        return Wizardry.settings.antiqueAtlasIntegration && antiqueAtlasLoaded;
    }

    public static void markTower(World world, int x, int z) {
        if (WizardryAntiqueAtlasIntegration.enabled() && Wizardry.settings.autoTowerMarkers) {
            AtlasAPI.getMarkerAPI().putGlobalMarker(world, false, TOWER_MARKER.toString(), "integration.antiqueatlas.marker." + TOWER_MARKER.toString(), x, z);
        }
    }

    public static void markObelisk(World world, int x, int z) {
        if (WizardryAntiqueAtlasIntegration.enabled() && Wizardry.settings.autoObeliskMarkers) {
            AtlasAPI.getMarkerAPI().putGlobalMarker(world, false, OBELISK_MARKER.toString(), "integration.antiqueatlas.marker." + OBELISK_MARKER.toString(), x, z);
        }
    }

    public static void markShrine(World world, int x, int z) {
        if (WizardryAntiqueAtlasIntegration.enabled() && Wizardry.settings.autoShrineMarkers) {
            AtlasAPI.getMarkerAPI().putGlobalMarker(world, false, SHRINE_MARKER.toString(), "integration.antiqueatlas.marker." + SHRINE_MARKER.toString(), x, z);
        }
    }

    public static void registerMarkers() {
        if (!WizardryAntiqueAtlasIntegration.enabled()) {
            return;
        }
        AtlasAPI.getMarkerAPI().registerMarker(new MarkerType(TOWER_MARKER, new ResourceLocation[]{new ResourceLocation("ebwizardry", "textures/integration/antiqueatlas/wizard_tower.png")}));
        AtlasAPI.getMarkerAPI().registerMarker(new MarkerType(SHRINE_MARKER, new ResourceLocation[]{new ResourceLocation("ebwizardry", "textures/integration/antiqueatlas/shrine.png")}));
        AtlasAPI.getMarkerAPI().registerMarker(new MarkerType(OBELISK_MARKER, new ResourceLocation[]{new ResourceLocation("ebwizardry", "textures/integration/antiqueatlas/obelisk.png")}));
    }
}

