/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import com.google.common.base.Predicate;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntityAIAttackSpell;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
public class EntityEvilWizard
extends EntityMob
implements ISpellCaster,
IEntityAdditionalSpawnData {
    private EntityAIAttackSpell<EntityEvilWizard> spellCastingAI = new EntityAIAttackSpell<EntityEvilWizard>(this, 0.5, 14.0f, 30, 50);
    public int textureIndex = 0;
    public boolean hasStructure = false;
    public final Set<UUID> groupUUIDs = new HashSet<UUID>();
    protected Predicate<Entity> targetSelector;
    private static final DataParameter<Integer> HEAL_COOLDOWN = EntityDataManager.func_187226_a(EntityEvilWizard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ELEMENT = EntityDataManager.func_187226_a(EntityEvilWizard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("ebwizardry", "entities/evil_wizard");
    private List<Spell> spells = new ArrayList<Spell>(4);
    private Spell continuousSpell;
    private int spellCounter;

    public EntityEvilWizard(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(3, this.spellCastingAI);
        this.func_110177_bN();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAL_COOLDOWN, (Object)-1);
        this.field_70180_af.func_187214_a(ELEMENT, (Object)-1);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.targetSelector = entity -> entity != null && !entity.func_82150_aj() && AllyDesignationSystem.isValidTarget((Entity)this, entity) && (entity instanceof EntityPlayer || (entity instanceof ISummonedCreature || entity instanceof EntityWizard || Arrays.asList(Wizardry.settings.summonedCreatureTargetsWhitelist).contains(EntityList.func_191306_a(entity.getClass()))) && !Arrays.asList(Wizardry.settings.summonedCreatureTargetsBlacklist).contains(EntityList.func_191306_a(entity.getClass())));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.targetSelector));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    private int getHealCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(HEAL_COOLDOWN);
    }

    private void setHealCooldown(int cooldown) {
        this.field_70180_af.func_187227_b(HEAL_COOLDOWN, (Object)cooldown);
    }

    public Element getElement() {
        int n = (Integer)this.field_70180_af.func_187225_a(ELEMENT);
        return n == -1 ? null : Element.values()[n];
    }

    public void setElement(Element element) {
        this.field_70180_af.func_187227_b(ELEMENT, (Object)element.ordinal());
    }

    @Override
    public List<Spell> getSpells() {
        return this.spells;
    }

    @Override
    public SpellModifiers getModifiers() {
        return new SpellModifiers();
    }

    @Override
    public void setContinuousSpell(Spell spell) {
        this.continuousSpell = spell;
    }

    @Override
    public Spell getContinuousSpell() {
        return this.continuousSpell;
    }

    @Override
    public void setSpellCounter(int count) {
        this.spellCounter = count;
    }

    @Override
    public int getSpellCounter() {
        return this.spellCounter;
    }

    @Override
    public int getAimingError(EnumDifficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return 7;
            }
            case NORMAL: {
                return 4;
            }
            case HARD: {
                return 1;
            }
        }
        return 7;
    }

    public void func_70604_c(@Nullable EntityLivingBase target) {
        if (target == null || !this.groupUUIDs.contains(target.func_110124_au())) {
            super.func_70604_c(target);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        int healCooldown = this.getHealCooldown();
        if (healCooldown == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() > 0.0f && !this.func_70644_a(WizardryPotions.arcane_jammer)) {
            this.func_70691_i(this.getElement() == Element.HEALING ? 8.0f : 4.0f);
            this.setHealCooldown(-1);
        } else if (healCooldown == -1 && this.field_70725_aQ == 0) {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double x = (float)this.field_70165_t + this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    double y = (float)this.field_70163_u - 0.5f + this.field_70146_Z.nextFloat();
                    double z = (float)this.field_70161_v + this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1f, 0.0).clr(1.0f, 1.0f, 0.3f).spawn(this.field_70170_p);
                }
            } else {
                if (this.func_110143_aJ() < 10.0f) {
                    this.setHealCooldown(150);
                } else {
                    this.setHealCooldown(400);
                }
                this.func_184185_a(Spells.heal.getSounds()[0], 0.7f, this.field_70146_Z.nextFloat() * 0.4f + 1.0f);
            }
        }
        if (healCooldown > 0) {
            this.setHealCooldown(healCooldown - 1);
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184812_l_() && stack.func_77973_b() instanceof ItemSpellBook) {
            Spell spell = Spell.byMetadata(stack.func_77952_i());
            if (this.spells.size() >= 4 && spell.canBeCastBy((EntityLiving)this, true)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:spell_book.apply_to_wizard", new Object[]{this.func_145748_c_(), this.spells.set(this.field_70146_Z.nextInt(3) + 1, spell).getNameForTranslationFormatted(), spell.getNameForTranslationFormatted()}));
                return true;
            }
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("element", this.getElement().ordinal());
        nbt.func_74768_a("skin", this.textureIndex);
        NBTExtras.storeTagSafely(nbt, "spells", (NBTBase)NBTExtras.listToNBT(this.spells, spell -> new NBTTagInt(spell.metadata())));
        nbt.func_74757_a("hasStructure", this.hasStructure);
        NBTExtras.storeTagSafely(nbt, "groupUUIDs", (NBTBase)NBTExtras.listToNBT(this.groupUUIDs, NBTUtil::func_186862_a));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setElement(Element.values()[nbt.func_74762_e("element")]);
        this.textureIndex = nbt.func_74762_e("skin");
        this.spells = (List)NBTExtras.NBTToList(nbt.func_150295_c("spells", 3), tag -> Spell.byMetadata(tag.func_150287_d()));
        this.hasStructure = nbt.func_74767_n("hasStructure");
        this.groupUUIDs.addAll(NBTExtras.NBTToList(nbt.func_150295_c("groupUUIDs", 10), NBTUtil::func_186860_b));
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean func_70692_ba() {
        return !this.hasStructure;
    }

    protected SoundEvent func_184639_G() {
        return WizardrySounds.ENTITY_EVIL_WIZARD_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return WizardrySounds.ENTITY_EVIL_WIZARD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WizardrySounds.ENTITY_EVIL_WIZARD_DEATH;
    }

    protected void func_70628_a(boolean hitByPlayer, int lootingLevel) {
        int j = 3 + this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + lootingLevel);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(WizardryItems.magic_crystal, 1);
        }
        if (this.spells.size() > 0 && this.field_70146_Z.nextInt(100) - lootingLevel < 5) {
            this.func_70099_a(new ItemStack(WizardryItems.spell_book, 1, this.spells.get(1 + this.field_70146_Z.nextInt(this.spells.size() - 1)).metadata()), 0.0f);
        }
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        data = super.func_180482_a(difficulty, data);
        this.textureIndex = this.field_70146_Z.nextInt(6);
        if (this.getElement() == null) {
            if (this.field_70146_Z.nextBoolean()) {
                this.setElement(Element.values()[this.field_70146_Z.nextInt(Element.values().length - 1) + 1]);
            } else {
                this.setElement(Element.MAGIC);
            }
        }
        Element element = this.getElement();
        for (EntityEquipmentSlot slot : WizardryUtilities.ARMOUR_SLOTS) {
            this.func_184201_a(slot, new ItemStack(WizardryItems.getArmour(element, slot)));
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.0f);
        }
        this.spells.add(Spells.magic_missile);
        Tier maxTier = EntityWizard.populateSpells((EntityLiving)this, this.spells, element, this.hasStructure, 3, this.field_70146_Z);
        Tier tier = Tier.values()[maxTier.ordinal() + this.field_70146_Z.nextInt(Tier.values().length - maxTier.ordinal())];
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(WizardryItems.getWand(tier, element)));
        return data;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.textureIndex);
    }

    public void readSpawnData(ByteBuf data) {
        this.textureIndex = data.readInt();
    }

    @SubscribeEvent
    public static void onCheckSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving() instanceof EntityEvilWizard && !event.isSpawner() && !ArrayUtils.contains((int[])Wizardry.settings.mobSpawnDimensions, (int)event.getWorld().field_73011_w.getDimension())) {
            event.setResult(Event.Result.DENY);
        }
    }
}

