/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketNPCCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityAIAttackSpell<T extends EntityLiving>
extends EntityAIBase {
    private final T attacker;
    private EntityLivingBase target;
    private int cooldown = -1;
    private final int baseCooldown;
    private int continuousSpellTimer;
    private final int continuousSpellDuration;
    private final double speed;
    private int seeTime;
    private final float maxAttackDistance;

    public EntityAIAttackSpell(T attacker, double speed, float maxDistance, int baseCooldown, int continuousSpellDuration) {
        this.attacker = attacker;
        this.baseCooldown = baseCooldown;
        this.continuousSpellDuration = continuousSpellDuration;
        this.speed = speed;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.target = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.attacker.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.cooldown = -1;
        this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
        this.continuousSpellTimer = 0;
    }

    private void setContinuousSpellAndNotify(Spell spell, SpellModifiers modifiers) {
        ((ISpellCaster)this.attacker).setContinuousSpell(spell);
        WizardryPacketHandler.net.sendToAllAround((IMessage)new PacketNPCCastSpell.Message(this.attacker.func_145782_y(), this.target == null ? -1 : this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers), new NetworkRegistry.TargetPoint(((EntityLiving)this.attacker).field_71093_bK, ((EntityLiving)this.attacker).field_70165_t, ((EntityLiving)this.attacker).field_70163_u, ((EntityLiving)this.attacker).field_70161_v, 128.0));
    }

    public void func_75246_d() {
        double distanceSq = this.attacker.func_70092_e(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v);
        boolean targetIsVisible = this.attacker.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = targetIsVisible ? ++this.seeTime : 0;
        if (distanceSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.attacker.func_70661_as().func_75499_g();
        } else {
            this.attacker.func_70661_as().func_75497_a((Entity)this.target, this.speed);
        }
        this.attacker.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (this.continuousSpellTimer > 0) {
            --this.continuousSpellTimer;
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible || MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), (EntityLivingBase)this.attacker, ((ISpellCaster)this.attacker).getModifiers(), this.continuousSpellDuration - this.continuousSpellTimer)) || !((ISpellCaster)this.attacker).getContinuousSpell().cast(((EntityLiving)this.attacker).field_70170_p, (EntityLiving)this.attacker, EnumHand.MAIN_HAND, this.continuousSpellDuration - this.continuousSpellTimer, this.target, ((ISpellCaster)this.attacker).getModifiers()) || this.continuousSpellTimer == 0) {
                this.continuousSpellTimer = 0;
                this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
                this.cooldown = this.baseCooldown;
                return;
            }
            if (this.continuousSpellDuration - this.continuousSpellTimer == 1) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), (EntityLivingBase)this.attacker, ((ISpellCaster)this.attacker).getModifiers()));
            }
        } else if (--this.cooldown == 0) {
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible) {
                return;
            }
            double dx = this.target.field_70165_t - ((EntityLiving)this.attacker).field_70165_t;
            double dz = this.target.field_70161_v - ((EntityLiving)this.attacker).field_70161_v;
            ArrayList<Spell> spells = new ArrayList<Spell>(((ISpellCaster)this.attacker).getSpells());
            if (spells.size() > 0 && !((EntityLiving)this.attacker).field_70170_p.field_72995_K) {
                while (!spells.isEmpty()) {
                    Spell spell = (Spell)spells.get(((EntityLiving)this.attacker).field_70170_p.field_73012_v.nextInt(spells.size()));
                    SpellModifiers modifiers = ((ISpellCaster)this.attacker).getModifiers();
                    if (spell != null && this.attemptCastSpell(spell, modifiers)) {
                        ((EntityLiving)this.attacker).field_70177_z = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        return;
                    }
                    spells.remove(spell);
                }
            }
        } else if (this.cooldown < 0) {
            this.cooldown = this.baseCooldown;
        }
    }

    private boolean attemptCastSpell(Spell spell, SpellModifiers modifiers) {
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, spell, (EntityLivingBase)this.attacker, modifiers))) {
            return false;
        }
        if (spell.cast(((EntityLiving)this.attacker).field_70170_p, (EntityLiving)this.attacker, EnumHand.MAIN_HAND, 0, this.target, modifiers)) {
            if (spell.isContinuous) {
                this.continuousSpellTimer = this.continuousSpellDuration - 1;
                this.setContinuousSpellAndNotify(spell, modifiers);
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, spell, (EntityLivingBase)this.attacker, modifiers));
                this.cooldown = this.baseCooldown + spell.getCooldown();
                if (spell.requiresPacket()) {
                    PacketNPCCastSpell.Message msg = new PacketNPCCastSpell.Message(this.attacker.func_145782_y(), this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, ((EntityLiving)this.attacker).field_70170_p.field_73011_w.getDimension());
                }
            }
            return true;
        }
        return false;
    }
}

