/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.WizardryUtilities;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityHammer
extends EntityMagicConstruct {
    public int fallTime;
    public boolean spin = false;

    public EntityHammer(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.9f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70145_X = false;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 3 == 0) {
            ParticleBuilder.create(ParticleBuilder.Type.SPARK).pos(this.field_70165_t - 0.5 + this.field_70146_Z.nextDouble(), this.field_70163_u + 2.0 * this.field_70146_Z.nextDouble(), this.field_70161_v - 0.5 + this.field_70146_Z.nextDouble()).spawn(this.field_70170_p);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        ++this.fallTime;
        this.field_70181_x -= (double)0.04f;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
            this.field_70125_A = 0.0f;
            this.spin = false;
            double seekerRange = Spells.lightning_hammer.getProperty("effect_radius").doubleValue();
            List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.field_70170_p);
            int maxTargets = Spells.lightning_hammer.getProperty("secondary_max_targets").intValue();
            while (targets.size() > maxTargets) {
                targets.remove(targets.size() - 1);
            }
            for (EntityLivingBase target : targets) {
                if (!WizardryUtilities.isLiving((Entity)target) || !this.isValidTarget((Entity)target) || (float)target.field_70173_aa % Spells.lightning_hammer.getProperty("attack_interval").floatValue() != 0.0f) continue;
                if (this.field_70170_p.field_72995_K) {
                    ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).pos(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O - 0.1, this.field_70161_v).target((Entity)target).spawn(this.field_70170_p);
                    ParticleBuilder.spawnShockParticles(this.field_70170_p, target.field_70165_t, target.func_174813_aQ().field_72338_b + (double)target.field_70131_O, target.field_70161_v);
                }
                target.func_184185_a(WizardrySounds.ENTITY_HAMMER_ATTACK, 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 1.5f);
                float damage = Spells.lightning_hammer.getProperty("splash_damage").floatValue() * this.damageMultiplier;
                if (this.getCaster() != null) {
                    WizardryUtilities.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.SHOCK), damage);
                    WizardryUtilities.applyStandardKnockback(this, target);
                    continue;
                }
                target.func_70097_a(DamageSource.field_76376_m, damage);
            }
        } else {
            if (this.spin) {
                this.func_70101_b(this.field_70177_z, this.field_70125_A + 15.0f);
            }
            List collided = this.field_70170_p.func_175674_a((Entity)this, this.func_70046_E(), e -> e instanceof EntityLivingBase);
            float damage = Spells.lightning_hammer.getProperty("direct_damage").floatValue() * this.damageMultiplier;
            for (Entity entity : collided) {
                entity.func_70097_a(MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.SHOCK), damage);
            }
        }
    }

    @Override
    public void despawn() {
        this.func_184185_a(WizardrySounds.ENTITY_HAMMER_EXPLODE, 1.0f, 1.0f);
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        super.despawn();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                double particleX = this.field_70165_t - 1.0 + 2.0 * this.field_70146_Z.nextDouble();
                double particleZ = this.field_70161_v - 1.0 + 2.0 * this.field_70146_Z.nextDouble();
                IBlockState block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v));
                if (block == null) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, this.field_70163_u, particleZ, particleX - this.field_70165_t, 0.0, particleZ - this.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
            }
        } else {
            if (this.field_70143_R > 10.0f) {
                EntityLightningBolt entitylightning = new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, false);
                this.field_70170_p.func_72942_c((Entity)entitylightning);
            }
            this.func_184185_a(WizardrySounds.ENTITY_HAMMER_LAND, 1.0f, 0.6f);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player == this.getCaster() && ItemArtefact.isArtefactActive(player, WizardryItems.ring_hammer) && player.func_184614_ca().func_190926_b() && this.field_70173_aa > 10) {
            this.func_70106_y();
            ItemStack hammer = new ItemStack(WizardryItems.lightning_hammer);
            if (!hammer.func_77942_o()) {
                hammer.func_77982_d(new NBTTagCompound());
            }
            hammer.func_77978_p().func_74768_a("duration", this.lifetime);
            hammer.func_77964_b(this.field_70173_aa);
            hammer.func_77978_p().func_74776_a("damageMultiplier", this.damageMultiplier);
            player.func_184611_a(EnumHand.MAIN_HAND, hammer);
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74774_a("Time", (byte)this.fallTime);
        nbttagcompound.func_74757_a("Spin", this.spin);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.fallTime = nbttagcompound.func_74771_c("Time") & 0xFF;
        this.spin = nbttagcompound.func_74767_n("Spin");
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeBoolean(this.spin);
        if (this.getCaster() != null) {
            data.writeInt(this.getCaster().func_145782_y());
        }
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.spin = data.readBoolean();
        if (!data.isReadable()) {
            return;
        }
        Entity entity = this.field_70170_p.func_73045_a(data.readInt());
        if (entity instanceof EntityLivingBase) {
            this.setCaster((EntityLivingBase)entity);
        } else {
            Wizardry.logger.warn("Lightning hammer caster with ID in spawn data not found");
        }
    }

    public boolean func_70112_a(double distance) {
        return true;
    }
}

