/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.enchantment;

import com.google.common.collect.Iterables;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardryEnchantments;
import electroblob.wizardry.spell.ImbueWeapon;
import java.util.Iterator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public interface Imbuement {
    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        for (EntityItem item : event.getDrops()) {
            Imbuement.removeImbuements(item.func_92059_d());
        }
    }

    @SubscribeEvent
    public static void onItemTossEvent(ItemTossEvent event) {
        Imbuement.removeImbuements(event.getEntityItem().func_92059_d());
    }

    public static void removeImbuements(ItemStack stack) {
        if (stack.func_77948_v()) {
            NBTTagList enchantmentList = stack.func_77973_b() == Items.field_151134_bR ? ItemEnchantedBook.func_92110_g((ItemStack)stack) : stack.func_77986_q();
            Iterator enchantmentIt = enchantmentList.iterator();
            while (enchantmentIt.hasNext()) {
                NBTTagCompound enchantmentTag = (NBTTagCompound)enchantmentIt.next();
                Enchantment enchantment = Enchantment.func_185262_c((int)enchantmentTag.func_74765_d("id"));
                if (!(enchantment instanceof Imbuement)) continue;
                enchantmentIt.remove();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerOpenContainerEvent(PlayerContainerEvent event) {
        if (event.getContainer() instanceof ContainerChest) {
            for (Slot slot : event.getContainer().field_75151_b) {
                NBTTagList enchantmentList;
                ItemStack slotStack = slot.func_75211_c();
                if (!(slotStack.func_77973_b() instanceof ItemEnchantedBook) || !Iterables.removeIf((Iterable)(enchantmentList = ItemEnchantedBook.func_92110_g((ItemStack)slotStack)), tag -> {
                    NBTTagCompound enchantmentTag = (NBTTagCompound)tag;
                    return Enchantment.func_185262_c((int)enchantmentTag.func_74765_d("id")) instanceof Imbuement;
                })) continue;
                if (enchantmentList.func_82582_d()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                    Wizardry.logger.info("Deleted enchanted book with illegal enchantments");
                    continue;
                }
                Wizardry.logger.info("Removed illegal enchantments from enchanted book");
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityLivingBase) {
                EntityLivingBase archer = (EntityLivingBase)arrow.field_70250_c;
                ItemStack bow = archer.func_184614_ca();
                if (!ImbueWeapon.isBow(bow.func_77973_b()) && !ImbueWeapon.isBow((bow = archer.func_184592_cb()).func_77973_b())) {
                    return;
                }
                int level = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.magic_bow, (ItemStack)bow);
                if (level > 0) {
                    arrow.func_70239_b(arrow.func_70242_d() + (double)level * 0.5 + 0.5);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.flaming_weapon, (ItemStack)bow) > 0) {
                    arrow.func_70015_d(100);
                }
                if ((level = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.freezing_weapon, (ItemStack)bow)) > 0 && arrow.getEntityData() != null) {
                    arrow.getEntityData().func_74768_a("frostLevel", level);
                }
            }
        }
    }
}

