/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.enchantment;

import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MagicDamage;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;

public class EnchantmentMagicProtection
extends Enchantment {
    public final Type protectionType;

    public EnchantmentMagicProtection(Enchantment.Rarity rarity, Type protectionType, EntityEquipmentSlot ... slots) {
        super(rarity, EnumEnchantmentType.ARMOR, slots);
        this.protectionType = protectionType;
    }

    public int func_77321_a(int enchantmentLevel) {
        return this.protectionType.getMinimalEnchantability() + (enchantmentLevel - 1) * this.protectionType.getEnchantIncreasePerLevel();
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + this.protectionType.getEnchantIncreasePerLevel();
    }

    public int func_77325_b() {
        return 4;
    }

    public int func_77318_a(int level, DamageSource source) {
        if (source.func_76357_e()) {
            return 0;
        }
        if (this.protectionType.protectsAgainst(source)) {
            return this.protectionType.getProtectionMultiplier() * level;
        }
        return 0;
    }

    public String func_77320_a() {
        return "enchantment.ebwizardry:" + this.protectionType.getTypeName() + "_protection";
    }

    public boolean func_77326_a(Enchantment ench) {
        if (ench instanceof EnchantmentMagicProtection) {
            return false;
        }
        if (ench instanceof EnchantmentProtection) {
            return ((EnchantmentProtection)ench).field_77356_a == EnchantmentProtection.Type.FALL;
        }
        return super.func_77326_a(ench);
    }

    public static enum Type {
        MAGIC("magic", 1, 5, 8, s -> s instanceof IElementalDamage),
        FROST("frost", 2, 10, 8, s -> s instanceof IElementalDamage && ((IElementalDamage)s).getType() == MagicDamage.DamageType.FROST),
        SHOCK("shock", 2, 10, 8, s -> s instanceof IElementalDamage && ((IElementalDamage)s).getType() == MagicDamage.DamageType.SHOCK);

        private final String typeName;
        private final int minEnchantability;
        private final int levelCost;
        private final Predicate<DamageSource> criteria;
        private final int protectionMultiplier;

        private Type(String name, int protectionMultiplier, int minEnchantability, int perLevelEnchantability, Predicate<DamageSource> criteria) {
            this.typeName = name;
            this.minEnchantability = minEnchantability;
            this.levelCost = perLevelEnchantability;
            this.criteria = criteria;
            this.protectionMultiplier = protectionMultiplier;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean protectsAgainst(DamageSource source) {
            return this.criteria.test(source);
        }

        public int getMinimalEnchantability() {
            return this.minEnchantability;
        }

        public int getEnchantIncreasePerLevel() {
            return this.levelCost;
        }

        public int getProtectionMultiplier() {
            return this.protectionMultiplier;
        }
    }
}

