/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import org.lwjgl.input.Keyboard;

public class GuiSpellBook
extends GuiScreen {
    private int xSize = 288;
    private int ySize = 180;
    private ItemSpellBook book;
    private Spell spell;

    public GuiSpellBook(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemSpellBook)) {
            throw new ClassCastException("Cannot create spell book GUI for item that does not extend ItemSpellBook!");
        }
        this.book = (ItemSpellBook)stack.func_77973_b();
        this.spell = Spell.byMetadata(stack.func_77952_i());
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int xPos = this.field_146294_l / 2 - this.xSize / 2;
        int yPos = this.field_146295_m / 2 - this.ySize / 2;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean discovered = true;
        if (Wizardry.settings.discoveryMode && !player.func_184812_l_() && WizardData.get((EntityPlayer)player) != null && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(this.spell)) {
            discovered = false;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(discovered ? this.spell.getIcon() : Spells.none.getIcon());
        DrawingUtils.drawTexturedRect(xPos + 146, yPos + 20, 0, 0, 128, 128, 128, 128);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.book.getGuiTexture(this.spell));
        DrawingUtils.drawTexturedRect(xPos, yPos, 0, 0, this.xSize, this.ySize, this.xSize, 256);
        super.func_73863_a(par1, par2, par3);
        if (discovered) {
            this.field_146289_q.func_78276_b(this.spell.getDisplayName(), xPos + 17, yPos + 15, 0);
            this.field_146289_q.func_78276_b(this.spell.getType().getDisplayName(), xPos + 17, yPos + 26, 0x777777);
        } else {
            this.field_146297_k.field_71464_q.func_78276_b(SpellGlyphData.getGlyphName(this.spell, player.field_70170_p), xPos + 17, yPos + 15, 0);
            this.field_146297_k.field_71464_q.func_78276_b(this.spell.getType().getDisplayName(), xPos + 17, yPos + 26, 0x777777);
        }
        if (this.spell.getTier() == Tier.NOVICE) {
            this.field_146289_q.func_78276_b("Tier: \u00a77" + Tier.NOVICE.getDisplayName(), xPos + 17, yPos + 45, 0);
        } else {
            this.field_146289_q.func_78276_b("Tier: " + this.spell.getTier().getDisplayNameWithFormatting(), xPos + 17, yPos + 45, 0);
        }
        String element = "Element: " + this.spell.getElement().getFormattingCode() + this.spell.getElement().getDisplayName();
        if (!discovered) {
            element = "Element: ?";
        }
        this.field_146289_q.func_78276_b(element, xPos + 17, yPos + 57, 0);
        String manaCost = "Mana Cost: " + this.spell.getCost();
        if (this.spell.isContinuous) {
            manaCost = "Mana Cost: " + this.spell.getCost() + "/second";
        }
        if (!discovered) {
            manaCost = "Mana Cost: ?";
        }
        this.field_146289_q.func_78276_b(manaCost, xPos + 17, yPos + 69, 0);
        if (discovered) {
            this.field_146289_q.func_78279_b(this.spell.getDescription(), xPos + 17, yPos + 83, 118, 0);
        } else {
            this.field_146297_k.field_71464_q.func_78279_b(SpellGlyphData.getGlyphDescription(this.spell, player.field_70170_p), xPos + 17, yPos + 83, 118, 0);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.MISC_BOOK_OPEN, (float)1.0f));
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return Wizardry.settings.booksPauseGame;
    }
}

