/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client;

import electroblob.wizardry.block.BlockMagicLight;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.data.DispenserCastingData;
import electroblob.wizardry.data.SpellEmitterData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemSpectralBow;
import electroblob.wizardry.potion.PotionSlowTime;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Possession;
import electroblob.wizardry.spell.SixthSense;
import electroblob.wizardry.spell.SlowTime;
import electroblob.wizardry.spell.Transience;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class WizardryClientEventHandler {
    private static final ResourceLocation sixthSenseTexture = new ResourceLocation("ebwizardry", "textures/entity/sixth_sense.png");
    private static final ResourceLocation sixthSenseOverlayTexture = new ResourceLocation("ebwizardry", "textures/gui/sixth_sense_overlay.png");
    private static final ResourceLocation frostOverlayTexture = new ResourceLocation("ebwizardry", "textures/gui/frost_overlay.png");
    private static final ResourceLocation blinkOverlayTexture = new ResourceLocation("ebwizardry", "textures/gui/blink_overlay.png");
    private static final ResourceLocation pointerTexture = new ResourceLocation("ebwizardry", "textures/entity/pointer.png");
    private static final ResourceLocation targetPointerTexture = new ResourceLocation("ebwizardry", "textures/entity/target_pointer.png");
    private static int blinkEffectTimer;
    private static final int BLINK_EFFECT_DURATION = 8;

    public static void playBlinkEffect() {
        blinkEffectTimer = 8;
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.player == Minecraft.func_71410_x().field_71439_g) {
            String activeShader;
            if (blinkEffectTimer > 0) {
                --blinkEffectTimer;
            }
            if (Minecraft.func_71410_x().field_71460_t.func_147706_e() != null && ((activeShader = Minecraft.func_71410_x().field_71460_t.func_147706_e().func_148022_b()).equals(SlowTime.SHADER.toString()) && !Minecraft.func_71410_x().field_71439_g.func_70644_a(WizardryPotions.slow_time) || activeShader.equals(SixthSense.SHADER.toString()) && !Minecraft.func_71410_x().field_71439_g.func_70644_a(WizardryPotions.sixth_sense) || activeShader.equals(Transience.SHADER.toString()) && !Minecraft.func_71410_x().field_71439_g.func_70644_a(WizardryPotions.transience))) {
                if (activeShader.equals(SixthSense.SHADER.toString()) || activeShader.equals(Transience.SHADER.toString())) {
                    WizardryClientEventHandler.playBlinkEffect();
                }
                Minecraft.func_71410_x().field_71460_t.func_181022_b();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderHandEvent(RenderHandEvent event) {
        EntityLiving victim = Possession.getPossessee((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (victim != null) {
            victim.field_70759_as = Minecraft.func_71410_x().field_71439_g.field_70177_z;
            if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_190926_b()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onInputUpdateEvent(InputUpdateEvent event) {
        if (event.getEntityPlayer().func_70644_a(WizardryPotions.paralysis)) {
            event.getMovementInput().field_192832_b = 0.0f;
            event.getMovementInput().field_78902_a = 0.0f;
            event.getMovementInput().field_78901_c = false;
            event.getMovementInput().field_78899_d = false;
        }
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T()) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            ArrayList tileEntities = new ArrayList(world.field_147482_g);
            for (TileEntity tileentity : tileEntities) {
                if (!(tileentity instanceof TileEntityDispenser) || DispenserCastingData.get((TileEntityDispenser)tileentity) == null) continue;
                DispenserCastingData.get((TileEntityDispenser)tileentity).update();
            }
            SpellEmitterData.update((World)world);
            PotionSlowTime.cleanUpEntities((World)world);
        }
    }

    @SubscribeEvent
    public static void onMouseEvent(MouseEvent event) {
        if (Minecraft.func_71410_x().field_71439_g.func_70644_a(WizardryPotions.paralysis) && Minecraft.func_71410_x().field_71415_G) {
            event.setCanceled(true);
            Minecraft.func_71410_x().field_71439_g.field_70126_B = 0.0f;
            Minecraft.func_71410_x().field_71439_g.field_70127_C = 0.0f;
            Minecraft.func_71410_x().field_71439_g.field_70177_z = 0.0f;
            Minecraft.func_71410_x().field_71439_g.field_70125_A = 0.0f;
        }
    }

    @SubscribeEvent
    public static void onFOVUpdateEvent(FOVUpdateEvent event) {
        if (event.getEntity().func_184587_cr() && event.getEntity().func_184607_cu().func_77973_b() instanceof ItemSpectralBow) {
            int maxUseTicks = event.getEntity().func_184612_cw();
            float maxUseSeconds = (float)maxUseTicks / 20.0f;
            maxUseSeconds = maxUseSeconds > 1.0f ? 1.0f : (maxUseSeconds *= maxUseSeconds);
            event.setNewfov(event.getFov() * 1.0f - maxUseSeconds * 0.15f);
        }
        if (blinkEffectTimer > 0) {
            float f = (float)Math.max(blinkEffectTimer - 2, 0) / 8.0f;
            event.setNewfov(event.getFov() + f * f * 0.7f);
        }
    }

    @SubscribeEvent
    public static void onDrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && event.getPlayer().field_70170_p.func_180495_p(event.getTarget().func_178782_a()).func_177230_c() instanceof BlockMagicLight && (!(event.getPlayer().func_184614_ca().func_77973_b() instanceof ISpellCastingItem) && !(event.getPlayer().func_184592_cb().func_77973_b() instanceof ISpellCastingItem) || !ItemArtefact.isArtefactActive(event.getPlayer(), WizardryItems.charm_light))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGuiDrawForegroundEvent(GuiContainerEvent.DrawForeground event) {
        if (event.getGuiContainer() instanceof GuiMerchant) {
            GuiMerchant gui = (GuiMerchant)event.getGuiContainer();
            if (gui.field_147002_h.func_75139_a(0).func_75211_c().func_77973_b() == WizardryItems.spell_book || gui.field_147002_h.func_75139_a(1).func_75211_c().func_77973_b() == WizardryItems.spell_book) {
                for (MerchantRecipe trade : gui.func_147035_g().func_70934_b((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    if (trade.func_77394_a().func_77973_b() != WizardryItems.spell_book || !trade.func_77396_b().func_190926_b()) continue;
                    Slot slot = gui.field_147002_h.func_75139_a(2);
                    DrawingUtils.drawItemAndTooltip((GuiContainer)gui, trade.func_77397_d(), slot.field_75223_e, slot.field_75221_f, event.getMouseX(), event.getMouseY(), gui.getSlotUnderMouse() == slot);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEvent(RenderLivingEvent.Post<EntityLivingBase> event) {
        BufferBuilder buffer;
        Tessellator tessellator;
        RayTraceResult rayTrace;
        Minecraft mc = Minecraft.func_71410_x();
        WizardData data = WizardData.get((EntityPlayer)mc.field_71439_g);
        RenderManager renderManager = event.getRenderer().func_177068_d();
        ItemStack wand = mc.field_71439_g.func_184614_ca();
        if (!(wand.func_77973_b() instanceof ISpellCastingItem)) {
            wand = mc.field_71439_g.func_184592_cb();
        }
        if (mc.field_71439_g.func_70093_af() && wand.func_77973_b() instanceof ISpellCastingItem && WizardryUtilities.isLiving((Entity)event.getEntity()) && data != null && data.selectedMinion != null && (rayTrace = RayTracer.standardEntityRayTrace((World)mc.field_71441_e, (Entity)mc.field_71439_g, 16.0, false)) != null && rayTrace.field_72308_g == event.getEntity()) {
            Tessellator tessellator2 = Tessellator.func_178181_a();
            BufferBuilder buffer2 = tessellator2.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)event.getEntity().field_70131_O + 0.5), (double)event.getZ());
            float yaw = mc.field_71474_y.field_74320_O == 2 ? renderManager.field_78732_j : -renderManager.field_78732_j;
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)yaw, (float)1.0f, (float)0.0f, (float)0.0f);
            buffer2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            mc.field_71446_o.func_110577_a(targetPointerTexture);
            buffer2.func_181662_b(-0.2, 0.24, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer2.func_181662_b(0.2, 0.24, 0.0).func_187315_a(0.5625, 0.0).func_181675_d();
            buffer2.func_181662_b(0.2, -0.24, 0.0).func_187315_a(0.5625, 0.6875).func_181675_d();
            buffer2.func_181662_b(-0.2, -0.24, 0.0).func_187315_a(0.0, 0.6875).func_181675_d();
            tessellator2.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
        if (data != null && data.selectedMinion != null && data.selectedMinion.get() == event.getEntity()) {
            tessellator = Tessellator.func_178181_a();
            buffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)event.getEntity().field_70131_O + 0.5), (double)event.getZ());
            float yaw = mc.field_71474_y.field_74320_O == 2 ? renderManager.field_78732_j : -renderManager.field_78732_j;
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)yaw, (float)1.0f, (float)0.0f, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            mc.field_71446_o.func_110577_a(pointerTexture);
            buffer.func_181662_b(-0.2, 0.24, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.2, 0.24, 0.0).func_187315_a(0.5625, 0.0).func_181675_d();
            buffer.func_181662_b(0.2, -0.24, 0.0).func_187315_a(0.5625, 0.6875).func_181675_d();
            buffer.func_181662_b(-0.2, -0.24, 0.0).func_187315_a(0.0, 0.6875).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
        if (mc.field_71439_g.func_70644_a(WizardryPotions.sixth_sense) && !(event.getEntity() instanceof EntityArmorStand) && event.getEntity() != mc.field_71439_g && mc.field_71439_g.func_70660_b(WizardryPotions.sixth_sense) != null && event.getEntity().func_70032_d((Entity)mc.field_71439_g) < Spells.sixth_sense.getProperty("effect_radius").floatValue() * (1.0f + (float)mc.field_71439_g.func_70660_b(WizardryPotions.sixth_sense).func_76458_c() * 0.25f)) {
            tessellator = Tessellator.func_178181_a();
            buffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179097_i();
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)event.getEntity().field_70131_O * 0.6), (double)event.getZ());
            float yaw = mc.field_71474_y.field_74320_O == 2 ? renderManager.field_78732_j : -renderManager.field_78732_j;
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)yaw, (float)1.0f, (float)0.0f, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            mc.field_71446_o.func_110577_a(sixthSenseTexture);
            buffer.func_181662_b(-0.6, 0.6, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.6, 0.6, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.6, -0.6, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-0.6, -0.6, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            if (Minecraft.func_71410_x().field_71439_g.func_70644_a(WizardryPotions.sixth_sense)) {
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179118_c();
                WizardryClientEventHandler.renderScreenOverlay(event, sixthSenseOverlayTexture);
                GlStateManager.func_179141_d();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (Minecraft.func_71410_x().field_71439_g.func_70644_a(WizardryPotions.frost)) {
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179118_c();
                WizardryClientEventHandler.renderScreenOverlay(event, frostOverlayTexture);
                GlStateManager.func_179141_d();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (blinkEffectTimer > 0) {
                float alpha = (float)blinkEffectTimer / 8.0f;
                OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179118_c();
                WizardryClientEventHandler.renderScreenOverlay(event, blinkOverlayTexture);
                GlStateManager.func_179141_d();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static void renderScreenOverlay(RenderGameOverlayEvent.Post event, ResourceLocation texture) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, (double)event.getResolution().func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)event.getResolution().func_78326_a(), (double)event.getResolution().func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)event.getResolution().func_78326_a(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }
}

