/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.block;

import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.tileentity.TileEntityPlayerSaveTimed;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.MagicDamage;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class BlockThorns
extends BlockBush
implements ITileEntityProvider {
    public static final int GROWTH_STAGES = 8;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final PropertyEnum<BlockDoublePlant.EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockDoublePlant.EnumBlockHalf.class);

    public BlockThorns() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7)));
        this.func_149711_c(4.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(null);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoublePlant.EnumBlockHalf.values()[meta / 8]).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta % 8));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockDoublePlant.EnumBlockHalf)state.func_177229_b(HALF)).ordinal() * 8 + (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, AGE});
    }

    public void placeAt(World world, BlockPos lowerPos, int flags) {
        world.func_180501_a(lowerPos, this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), flags);
        world.func_180501_a(lowerPos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), flags);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 2);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (state.func_177229_b(HALF) == BlockDoublePlant.EnumBlockHalf.LOWER) {
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                world.func_175655_b(pos.func_177984_a(), false);
            }
        } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175655_b(pos.func_177977_b(), false);
        }
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(HALF) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
        return iblockstate.func_177230_c() == this && this.func_185514_i(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && BlockThorns.applyThornDamage(world, pos, entity)) {
            entity.func_70110_aj();
        }
    }

    private static boolean applyThornDamage(World world, BlockPos pos, Entity target) {
        DamageSource source = DamageSource.field_76367_g;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityPlayerSaveTimed) {
            if (AllyDesignationSystem.isValidTarget((Entity)((TileEntityPlayerSaveTimed)tileentity).getCaster(), target)) {
                source = MagicDamage.causeDirectMagicDamage((Entity)((TileEntityPlayerSaveTimed)tileentity).getCaster(), MagicDamage.DamageType.MAGIC);
            } else {
                return false;
            }
        }
        if (world.func_82737_E() % 20L == 0L) {
            target.func_70097_a(source, Spells.forest_of_thorns.getProperty("damage").floatValue());
        }
        return true;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPlayerSaveTimed(600);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_185915_l();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @SubscribeEvent
    public static void onLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getWorld().func_82737_E() % 20L == 0L && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == WizardryBlocks.thorns) {
            BlockThorns.applyThornDamage(event.getWorld(), event.getPos(), event.getEntity());
        }
    }
}

