/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.SpellEmitterData;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.event.DiscoverSpellEvent;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.packet.PacketSyncAdvancements;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryEnchantments;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.ImbueWeapon;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public final class WizardryEventHandler {
    private static final double LIVING_ENTITY_GRAVITY = 0.08;
    private static final double LIVING_ENTITY_DRAG = 0.98;
    private static final double LIVING_ENTITY_TERMINAL_VELOCITY = 3.92;
    private static final double LOG_LIVING_ENTITY_DRAG = Math.log(0.98);
    private static final double FALL_TICKS_ERROR_CORRECTION = 0.500841776608447;

    private WizardryEventHandler() {
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            SpellGlyphData.get(event.player.field_70170_p).sync((EntityPlayerMP)event.player);
            SpellEmitterData.get(event.player.field_70170_p).sync((EntityPlayerMP)event.player);
            Wizardry.settings.sync((EntityPlayerMP)event.player);
            WizardryEventHandler.syncAdvancements((EntityPlayerMP)event.player, false);
        }
        Spell.syncProperties(event.player);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
        if (event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).func_70644_a(WizardryPotions.muffle)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAdvancementEvent(AdvancementEvent event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && event.getEntityPlayer().field_70173_aa > 0) {
            WizardryEventHandler.syncAdvancements((EntityPlayerMP)event.getEntityPlayer(), true);
        }
    }

    private static void syncAdvancements(EntityPlayerMP player, boolean showToasts) {
        Wizardry.logger.info("Synchronising advancements for " + player.func_70005_c_());
        ArrayList<ResourceLocation> advancements = new ArrayList<ResourceLocation>();
        for (Advancement advancement : player.func_184102_h().func_191949_aK().func_192780_b()) {
            if (!player.func_192039_O().func_192747_a(advancement).func_192105_a()) continue;
            advancements.add(advancement.func_192067_g());
        }
        WizardryPacketHandler.net.sendTo((IMessage)new PacketSyncAdvancements.Message(showToasts, advancements.toArray(new ResourceLocation[0])), player);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        boolean enabled = true;
        switch (event.getSource()) {
            case WAND: {
                enabled = event.getSpell().isEnabled(SpellProperties.Context.WANDS);
                break;
            }
            case SCROLL: {
                enabled = event.getSpell().isEnabled(SpellProperties.Context.SCROLL);
                break;
            }
            case COMMAND: {
                enabled = event.getSpell().isEnabled(SpellProperties.Context.COMMANDS);
                break;
            }
            case NPC: {
                enabled = event.getSpell().isEnabled(SpellProperties.Context.NPCS);
                break;
            }
            case DISPENSER: {
                enabled = event.getSpell().isEnabled(SpellProperties.Context.DISPENSERS);
                break;
            }
            case OTHER: {
                enabled = event.getSpell().isEnabled(new SpellProperties.Context[0]);
            }
        }
        if (!enabled) {
            if (event.getCaster() != null && !event.getCaster().field_70170_p.field_72995_K) {
                event.getCaster().func_145747_a((ITextComponent)new TextComponentTranslation("spell.disabled", new Object[]{event.getSpell().getNameForTranslationFormatted()}));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        if (event.getCaster() instanceof EntityPlayer) {
            WizardData data;
            EntityPlayer player = (EntityPlayer)event.getCaster();
            if (player instanceof EntityPlayerMP) {
                WizardryAdvancementTriggers.cast_spell.trigger((EntityPlayerMP)player, event.getSpell(), player.func_184586_b(player.func_184600_cs()));
            }
            if ((data = WizardData.get(player)) != null && !MinecraftForge.EVENT_BUS.post((Event)new DiscoverSpellEvent(player, event.getSpell(), DiscoverSpellEvent.Source.CASTING)) && data.discoverSpell(event.getSpell())) {
                if (event.getSource() == SpellCastEvent.Source.COMMAND) {
                    if (!event.getSpell().requiresPacket()) {
                        data.sync();
                    }
                } else if (!event.getCaster().field_70170_p.field_72995_K && !player.func_184812_l_() && Wizardry.settings.discoveryMode) {
                    WizardryUtilities.playSoundAtPlayer(player, WizardrySounds.MISC_DISCOVER_SPELL, 1.25f, 1.0f);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("spell.discover", new Object[]{event.getSpell().getNameForTranslationFormatted()}));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDiscoverSpellEvent(DiscoverSpellEvent event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            WizardryAdvancementTriggers.discover_spell.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getSpell(), event.getSource());
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null && event.getEntityLiving() instanceof EntityLiving && event.getTarget().func_70644_a(WizardryPotions.muffle)) {
            Vec3d vec = event.getTarget().func_174824_e(1.0f).func_178788_d(event.getEntity().func_174824_e(1.0f));
            double angle = Math.acos(vec.func_72430_b(event.getEntity().func_70040_Z()) / vec.func_72433_c());
            System.out.println(angle);
            if (angle > 1.2566370614359172) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (!(event.getSource() == null || !(event.getSource().func_76346_g() instanceof EntityLivingBase) || event.getSource().func_76352_a() || event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory())) {
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            World world = event.getEntityLiving().field_70170_p;
            if (attacker.func_70032_d((Entity)event.getEntityLiving()) < 10.0f) {
                if (event.getEntityLiving().func_70644_a(WizardryPotions.fireskin) && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)event.getEntityLiving())) {
                    attacker.func_70015_d(Spells.fire_breath.getProperty("burn_duration").intValue());
                }
                if (event.getEntityLiving().func_70644_a(WizardryPotions.ice_shroud) && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)event.getEntityLiving()) && !(attacker instanceof FakePlayer)) {
                    attacker.func_70690_d(new PotionEffect(WizardryPotions.frost, Spells.ice_shroud.getProperty("effect_duration").intValue(), Spells.ice_shroud.getProperty("effect_strength").intValue()));
                }
                if (event.getEntityLiving().func_70644_a(WizardryPotions.static_aura)) {
                    if (world.field_72995_K) {
                        ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity(event.getEntity()).pos(0.0, event.getEntity().field_70131_O / 2.0f, 0.0).target((Entity)attacker).spawn(world);
                        ParticleBuilder.spawnShockParticles(world, attacker.field_70165_t, attacker.func_174813_aQ().field_72338_b + (double)(attacker.field_70131_O / 2.0f), attacker.field_70161_v);
                    }
                    DamageSafetyChecker.attackEntitySafely((Entity)attacker, MagicDamage.causeDirectMagicDamage((Entity)event.getEntityLiving(), MagicDamage.DamageType.SHOCK, true), Spells.static_aura.getProperty("damage").floatValue(), event.getSource().func_76355_l());
                    attacker.func_184185_a(WizardrySounds.SPELL_STATIC_AURA_RETALIATE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        int level;
        EntityLivingBase attacker;
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && !(attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_190926_b() && ImbueWeapon.isSword(attacker.func_184614_ca().func_77973_b())) {
            int level2 = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.flaming_weapon, (ItemStack)attacker.func_184614_ca());
            if (level2 > 0 && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)event.getEntityLiving())) {
                event.getEntityLiving().func_70015_d(level2 * 4);
            }
            if ((level2 = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.freezing_weapon, (ItemStack)attacker.func_184614_ca())) > 0 && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)event.getEntityLiving())) {
                event.getEntityLiving().func_70690_d(new PotionEffect(WizardryPotions.frost, level2 * 200, 0));
            }
        }
        if (event.getSource().func_76364_f() instanceof EntityArrow && event.getSource().func_76364_f().getEntityData() != null && (level = event.getSource().func_76364_f().getEntityData().func_74762_e("frostLevel")) > 0 && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)event.getEntityLiving())) {
            event.getEntityLiving().func_70690_d(new PotionEffect(WizardryPotions.frost, level * 150, 0));
        }
        if (event.getSource() != null && event.getSource() instanceof IElementalDamage) {
            if (event.getSource().func_76346_g() instanceof EntityPlayer) {
                event.setAmount((float)((double)event.getAmount() * Wizardry.settings.playerDamageScale));
            } else {
                event.setAmount((float)((double)event.getAmount() * Wizardry.settings.npcDamageScale));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K && event.getEntity() instanceof ISpellCaster && event.getEntity() instanceof EntityLiving) {
            Spell spell = ((ISpellCaster)event.getEntity()).getContinuousSpell();
            SpellModifiers modifiers = ((ISpellCaster)event.getEntity()).getModifiers();
            int count = ((ISpellCaster)event.getEntity()).getSpellCounter();
            if (spell != null && spell != Spells.none && !MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.NPC, spell, event.getEntityLiving(), modifiers, count))) {
                spell.cast(event.getEntity().field_70170_p, (EntityLiving)event.getEntity(), EnumHand.MAIN_HAND, count, ((EntityLiving)event.getEntity()).func_70638_az(), modifiers);
            }
            ((ISpellCaster)event.getEntity()).setSpellCounter(count + 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (event.getEntity().getClass().getCanonicalName().contains("lycanitesmobs")) {
                WorldServer world = (WorldServer)event.getEntity().func_130014_f_();
                LootTable table = world.func_184146_ak().func_186521_a(new ResourceLocation("ebwizardry", "entities/mob_additions"));
                LootContext ctx = new LootContext.Builder(world).func_186470_a(player).func_186471_a();
                List stacks = table.func_186462_a(world.field_73012_v, ctx);
                for (ItemStack stack : stacks) {
                    event.getEntity().func_70099_a(stack, 0.0f);
                }
            }
            for (ItemStack stack : WizardryUtilities.getPrioritisedHotbarAndOffhand(player)) {
                if (!(stack.func_77973_b() instanceof IManaStoringItem) || ((IManaStoringItem)stack.func_77973_b()).isManaFull(stack) || WandHelper.getUpgradeLevel(stack, WizardryItems.siphon_upgrade) <= 0) continue;
                int mana = 5 * WandHelper.getUpgradeLevel(stack, WizardryItems.siphon_upgrade) + player.field_70170_p.field_73012_v.nextInt(5);
                if (ItemArtefact.isArtefactActive(player, WizardryItems.ring_siphoning)) {
                    mana = (int)((float)mana * 1.3f);
                }
                ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, mana);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFallEvent(LivingFallEvent event) {
        if (Wizardry.settings.replaceVanillaFallDamage && !Loader.isModLoaded((String)"speedbasedfalldamage")) {
            WizardData data;
            double v = event.getEntity().field_70181_x;
            if (event.getEntity() instanceof EntityPlayer && (data = WizardData.get((EntityPlayer)event.getEntity())) != null) {
                v = data.prevMotionY;
            }
            if (v > -3.9) {
                double y;
                double g = 0.08;
                double f = 0.98;
                double lnf = LOG_LIVING_ENTITY_DRAG;
                double tv = 3.92;
                double t = Math.log((-v - tv) * lnf / g) / lnf;
                if ((y = g * Math.pow(f, t -= 0.500841776608447) / (lnf * lnf) + tv * t - 196.0) < (double)event.getDistance()) {
                    event.setDistance((float)y);
                }
            }
        }
    }
}

